/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class MoHttpUtils {
    private static final Logger LOGGER = Logger.getLogger(MoHttpUtils.class.getName());

    public static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = SSLContexts.custom().build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        CloseableHttpClient httpclient = builder.build();
        return httpclient;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String sendGetRequest(String url, HashMap<String, String> headers) throws IOException {
        LOGGER.info("MoHttpUtils sendGetRequest Sending GET request to " + url);
        try (CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();){
            String string;
            block24: {
                CloseableHttpResponse response;
                block22: {
                    String string2;
                    block23: {
                        LOGGER.fine("MoHttpUtils sendGetRequest Sending GET request to " + url);
                        HttpGet getRequest = new HttpGet(url);
                        if (headers != null) {
                            for (Map.Entry<String, String> entry : headers.entrySet()) {
                                getRequest.setHeader(entry.getKey(), entry.getValue());
                            }
                        }
                        response = httpClient.execute((HttpUriRequest)getRequest);
                        int statusCode = response.getStatusLine().getStatusCode();
                        LOGGER.fine("Response for HTTP Request: " + response.toString() + " and Status Code: " + statusCode);
                        if (statusCode != 200 || response.getEntity() == null) break block22;
                        LOGGER.fine("Response Entity found. Reading Response payload.");
                        String payload = EntityUtils.toString((HttpEntity)response.getEntity());
                        LOGGER.fine("Response payload: " + payload);
                        string2 = payload;
                        if (response == null) break block23;
                        response.close();
                    }
                    return string2;
                }
                LOGGER.fine("Response Entity NOT found or Status Code is not OK. Returning EMPTY string.");
                string = "";
                if (response == null) break block24;
                {
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ClientProtocolException e) {
                            String string3 = "";
                            return string3;
                        }
                    }
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            LOGGER.fine("An exception occurred while sending get request: " + e.getMessage());
            return "";
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            return "";
        }
    }
}

