/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.orka;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import io.jenkins.plugins.orka.helpers.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class IdleTimeCloudRetentionStrategy
extends CloudRetentionStrategy {
    private int idleMinutes;
    public static final int RECOMMENDED_MIN_IDLE = 30;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public IdleTimeCloudRetentionStrategy(int idleMinutes) {
        super(Utils.normalizeIdleTime(idleMinutes, 30));
        this.idleMinutes = Utils.normalizeIdleTime(idleMinutes, 30);
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public String toString() {
        return "IdleTimeCloudRetentionStrategy [idleMinutes=" + this.idleMinutes + "]";
    }

    private Object readResolve() {
        this.idleMinutes = Utils.normalizeIdleTime(this.idleMinutes, 30);
        return new IdleTimeCloudRetentionStrategy(this.idleMinutes);
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Keep until idle time expires";
        }

        public FormValidation doCheckIdleMinutes(@QueryParameter String value) {
            return Utils.checkInputValue(value);
        }
    }
}

