/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.localization.support.stapler;

import io.jenkins.plugins.localization.support.LocalizationContributor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.jelly.ResourceBundle;
import org.kohsuke.stapler.jelly.ResourceBundleFactory;

@Restricted(value={NoExternalUse.class})
public final class ResourceBundleFactoryImpl
extends ResourceBundleFactory {
    private static final String DEVELOPMENT_RESOURCES = "src/main/resources";
    private static final String JAR_INDICATOR = ".jar!";
    private static final Logger LOGGER = Logger.getLogger(ResourceBundleFactoryImpl.class.getName());

    public ResourceBundle create(String baseName) {
        return new ResourceBundle2(baseName);
    }

    private static class ResourceBundle2
    extends ResourceBundle {
        private ResourceBundle2(String baseName) {
            super(baseName);
        }

        protected Properties wrapUp(String locale, Properties props) {
            String cleanBaseName = "";
            if (this.getBaseName().contains(ResourceBundleFactoryImpl.JAR_INDICATOR)) {
                cleanBaseName = this.getBaseName().substring(this.getBaseName().indexOf(ResourceBundleFactoryImpl.JAR_INDICATOR) + ResourceBundleFactoryImpl.JAR_INDICATOR.length());
            } else if (this.getBaseName().contains(ResourceBundleFactoryImpl.DEVELOPMENT_RESOURCES)) {
                cleanBaseName = this.getBaseName().substring(this.getBaseName().indexOf(ResourceBundleFactoryImpl.DEVELOPMENT_RESOURCES) + ResourceBundleFactoryImpl.DEVELOPMENT_RESOURCES.length());
            }
            String name = cleanBaseName + "_" + locale + ".properties";
            URL url = LocalizationContributor.findResource(name, ((Object)((Object)this)).getClass());
            if (url != null) {
                try (InputStream stream = url.openStream();){
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(stream);
                    Enumeration<String> keys = propertyResourceBundle.getKeys();
                    ArrayList<String> keysAsSaneType = Collections.list(keys);
                    for (String localKey : keysAsSaneType) {
                        String value = propertyResourceBundle.getString(localKey);
                        props.setProperty(localKey, value);
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Failed to load localized resources file " + name, ex);
                }
            }
            return props;
        }
    }
}

