/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.EphemeralContainerBuilder;
import io.fabric8.kubernetes.api.model.EphemeralContainerFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerMonitor;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStep;
import java.util.List;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;

class KubernetesClientModelFactory {
    KubernetesClientModelFactory() {
    }

    @NonNull
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="not applicable")
    static EphemeralContainer createEphemeralContainer(@NonNull String containerName, @NonNull EphemeralContainerStep step, @NonNull Pod pod) {
        List<EnvVar> envVars = step.getEnvVars().stream().map(TemplateEnvVar::buildEnvVar).toList();
        EphemeralContainerBuilder containerBuilder = (EphemeralContainerBuilder)((EphemeralContainerBuilder)((EphemeralContainerBuilder)((EphemeralContainerBuilder)((EphemeralContainerBuilder)((EphemeralContainerBuilder)((EphemeralContainerBuilder)new EphemeralContainerBuilder().withName(containerName)).withTargetContainerName(step.getTargetContainer())).withTty(Boolean.valueOf(true))).withStdin(Boolean.valueOf(true))).withImage(step.getImage())).withImagePullPolicy(step.isAlwaysPullImage() ? "Always" : "IfNotPresent")).withEnv(envVars);
        pod.getSpec().getContainers().stream().filter(c -> "jnlp".equals(c.getName())).findFirst().ifPresent(container -> ((EphemeralContainerBuilder)containerBuilder.withVolumeMounts(container.getVolumeMounts().toArray(new VolumeMount[0]))).withWorkingDir(container.getWorkingDir()));
        if (step.getRunAsUser() != null || step.getRunAsGroup() != null) {
            ((EphemeralContainerFluent.SecurityContextNested)((EphemeralContainerFluent.SecurityContextNested)containerBuilder.withNewSecurityContext().withRunAsUser(step.getRunAsUserLong())).withRunAsGroup(step.getRunAsGroupLong())).endSecurityContext();
        }
        String[] monitorCmd = EphemeralContainerMonitor.containerWaitCommand(containerName);
        List<String> stepCmd = step.getCommand();
        if (stepCmd == null) {
            containerBuilder.withArgs(monitorCmd);
        } else if (stepCmd.isEmpty()) {
            containerBuilder.withCommand(monitorCmd);
        } else {
            containerBuilder.withCommand(stepCmd);
            containerBuilder.withArgs(monitorCmd);
        }
        return containerBuilder.build();
    }
}

