/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kryptowire.workflow;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.GlobalConfiguration;
import org.aerogear.kryptowire.BinaryHistoryAction;
import org.aerogear.kryptowire.BinaryInfo;
import org.aerogear.kryptowire.GlobalConfigurationImpl;
import org.aerogear.kryptowire.KryptowireServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KWSubmitStep
extends AbstractStepImpl {
    private String platform;
    private String filePath;
    private String kwAPIKey;
    private String appiumScript;

    public String getPlatform() {
        return this.platform;
    }

    @DataBoundSetter
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @DataBoundSetter
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getApiKey() {
        return this.kwAPIKey;
    }

    @DataBoundSetter
    public void setApiKey(String apiKey) {
        this.kwAPIKey = apiKey;
    }

    public String getAppiumScript() {
        return this.appiumScript;
    }

    @DataBoundSetter
    public void setAppiumScript(String appiumScript) {
        this.appiumScript = appiumScript;
    }

    @DataBoundConstructor
    public KWSubmitStep(@Nonnull String platform, @Nonnull String filePath) {
        this.platform = platform;
        this.filePath = filePath;
    }

    public static class KWSubmitExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        transient KWSubmitStep step;
        @StepContextParameter
        transient TaskListener listener;
        @StepContextParameter
        private transient Run build;

        protected Void run() throws Exception {
            GlobalConfigurationImpl pluginConfig = (GlobalConfigurationImpl)((Object)GlobalConfiguration.all().get(GlobalConfigurationImpl.class));
            if (pluginConfig == null) {
                throw new RuntimeException("[Error] Could not retrieve global Kryptowire config object.");
            }
            String kwEndpoint = pluginConfig.getKwEndpoint();
            String kwApiKey = this.step.kwAPIKey;
            this.listener.getLogger().println(" --- APIKey: " + kwApiKey);
            if (kwApiKey == null || kwApiKey.isEmpty()) {
                kwApiKey = pluginConfig.getKwApiKey();
            }
            if (StringUtils.isEmpty((String)kwEndpoint)) {
                throw new RuntimeException("Kryptowire plugin configuration is not correct: Endpoint is not set!");
            }
            if (StringUtils.isEmpty((String)kwApiKey)) {
                throw new RuntimeException("Kryptowire plugin configuration is not correct: API Key is not passed in the Jenkinsfile, nor set in the plugin configuration.");
            }
            FilePath fp = ((FilePath)this.getContext().get(FilePath.class)).child(this.step.filePath);
            FilePath appiumScriptFp = null;
            if (this.step.appiumScript != null && !this.step.appiumScript.isEmpty()) {
                appiumScriptFp = ((FilePath)this.getContext().get(FilePath.class)).child(this.step.appiumScript);
            }
            this.listener.getLogger().println(" --- Kryptowire submit Start ---");
            this.listener.getLogger().println("kwSubmit: " + this.step.platform + " : " + this.step.filePath);
            if (appiumScriptFp != null) {
                this.listener.getLogger().println("kwSubmit appium_script: " + this.step.appiumScript);
            }
            KryptowireServiceImpl kws = new KryptowireServiceImpl(kwEndpoint, kwApiKey);
            JSONObject resp = kws.submit(this.step.platform, fp, appiumScriptFp);
            String uuid = resp.getString("uuid");
            String platform = resp.getString("platform");
            String pkg = resp.getString("package");
            String version = resp.getString("version");
            String hash = resp.getString("hash");
            this.listener.getLogger().println("kw msg: " + String.valueOf(resp.get("msg")));
            this.listener.getLogger().println("kw uuid: " + uuid);
            this.listener.getLogger().println("kw platform: " + platform);
            this.listener.getLogger().println("kw package: " + pkg);
            this.listener.getLogger().println("kw version: " + version);
            this.listener.getLogger().println("kw hash: " + hash);
            BinaryInfo info = BinaryInfo.fromJSONObject(resp);
            this.build.addAction((Action)new BinaryHistoryAction(info));
            this.listener.getLogger().println(" --- Kryptowire submit Done ---");
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(KWSubmitExecution.class);
        }

        public String getFunctionName() {
            return "kwSubmit";
        }

        public String getDisplayName() {
            return "Submit to Kryptowire";
        }
    }
}

