/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kryptowire;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class GlobalConfigurationImpl
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalConfigurationImpl.class.getName());
    private String kwApiKey;
    private String kwEndpoint;

    public GlobalConfigurationImpl() {
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    public String getGlobalConfigPage() {
        return super.getGlobalConfigPage();
    }

    @DataBoundConstructor
    public GlobalConfigurationImpl(String kwApiKey, String kwEndpoint) {
        this.load();
        this.setKwApiKey(kwApiKey);
        this.setKwEndpoint(kwEndpoint);
    }

    public String getKwApiKey() {
        return this.kwApiKey;
    }

    public void setKwApiKey(String kwApiKey) {
        this.kwApiKey = kwApiKey;
    }

    public String getKwEndpoint() {
        return this.kwEndpoint;
    }

    public void setKwEndpoint(String kwEndpoint) {
        this.kwEndpoint = kwEndpoint;
    }

    public FormValidation doCheckKwApiKey(@QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.isEmpty((String)value)) {
            LOGGER.info("[info] Missing kryptowire api key field");
            return FormValidation.error((String)"You must provide a kryptowire api key.");
        }
        LOGGER.info("[info] Kryptowire api key validated.");
        return FormValidation.ok();
    }

    public FormValidation doCheckKwEndpoint(@QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.isEmpty((String)value)) {
            LOGGER.info("[info] Missing kryptowire endpoinf field");
            return FormValidation.error((String)"You must provide a kryptowire endpoint");
        }
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (!urlValidator.isValid(value)) {
            LOGGER.info("[info] Failed to validate the kryptowire endpoint as a valid url string.");
            return FormValidation.error((String)"Invalid kryptowire endpoint format");
        }
        LOGGER.info("[info] Kryptowire endpoint field validated.");
        return FormValidation.ok();
    }

    public String getDisplayName() {
        return "Kryptowire Global Config";
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
        LOGGER.info("[info] Kryptowire global configuration updated.");
        return super.configure(req, formData);
    }
}

