/*
 * Decompiled with CFR 0.152.
 */
package com.github.cyanbaz.jenkins.plugins.jsonparameter;

import com.github.cyanbaz.jenkins.plugins.jsonparameter.AbstractJsonParameterDefinition;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonResult;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.JsonSource;
import com.github.cyanbaz.jenkins.plugins.jsonparameter.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class JsonParameterReferenceDefinition
extends AbstractJsonParameterDefinition {
    private static final long serialVersionUID = 1L;
    private final String ref;

    @DataBoundConstructor
    public JsonParameterReferenceDefinition(String name, String defaultValue, JsonSource source, String query, String ref) {
        super(name, defaultValue, source, query);
        this.ref = ref;
    }

    public String getRef() {
        return this.ref;
    }

    @Extension
    @Symbol(value={"jsonParamRef"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());

        @NonNull
        public String getDisplayName() {
            return "JSON Reference Parameter";
        }

        @RequirePOST
        @POST
        public HttpResponse doLoadOptions(@AncestorInPath Job<?, ?> job, @QueryParameter String paramName, @QueryParameter String refValue) {
            String effectiveSelection;
            JsonResult<ListBoxModel> items;
            if (job == null) {
                return HttpResponses.errorJSON((String)Messages.error_no_job_context());
            }
            job.checkPermission(Item.READ);
            ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            if (parametersDefinitionProperty == null) {
                return HttpResponses.errorJSON((String)Messages.error_no_parameter());
            }
            ParameterDefinition parameterDefinition = parametersDefinitionProperty.getParameterDefinition(paramName);
            if (!(parameterDefinition instanceof JsonParameterReferenceDefinition)) {
                return HttpResponses.errorJSON((String)Messages.error_parameter_not_found(paramName));
            }
            JsonParameterReferenceDefinition jsonParameterReferenceDefinition = (JsonParameterReferenceDefinition)parameterDefinition;
            JsonSource source = jsonParameterReferenceDefinition.getSource();
            String query = jsonParameterReferenceDefinition.getQuery();
            if (query == null || query.isBlank()) {
                return HttpResponses.errorJSON((String)Messages.error_missing_query());
            }
            String refName = jsonParameterReferenceDefinition.getRef();
            if (refName == null || refName.isBlank()) {
                return HttpResponses.errorJSON((String)Messages.error_missing_refName());
            }
            refValue = refValue != null ? refValue : "";
            String placeholder = "${" + refName + "}";
            if (query.contains(placeholder)) {
                query = query.replace(placeholder, refValue);
            }
            try {
                items = source.loadOptions(query);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "loadOptions failed", exception);
                return HttpResponses.errorJSON((String)String.valueOf(exception.getMessage()));
            }
            String defaultValue = jsonParameterReferenceDefinition.getDefaultValue();
            String string = defaultValue != null && !defaultValue.isBlank() ? defaultValue : (effectiveSelection = jsonParameterReferenceDefinition.getDefaultValue() != null ? jsonParameterReferenceDefinition.getDefaultValue() : "");
            if (items.isSuccess() && !effectiveSelection.isBlank()) {
                for (ListBoxModel.Option option : items.getValue()) {
                    option.selected = effectiveSelection.equals(option.value);
                }
            }
            return HttpResponses.okJSON((JSONArray)this.toJsonArray(items));
        }

        private JSONArray toJsonArray(JsonResult<ListBoxModel> items) {
            JSONArray jsonArray = new JSONArray();
            if (items.isSuccess()) {
                ListBoxModel model = items.getValue();
                for (ListBoxModel.Option option : model) {
                    JSONObject obj = new JSONObject();
                    obj.put("name", (Object)option.name);
                    obj.put("value", (Object)option.value);
                    obj.put("selected", (Object)option.selected);
                    jsonArray.add((Object)obj);
                }
            } else {
                JSONObject errorObj = new JSONObject();
                errorObj.put("name", (Object)Messages.placeholder_no_reference_value());
                errorObj.put("value", (Object)"");
                errorObj.put("selected", (Object)false);
                jsonArray.add((Object)errorObj);
            }
            return jsonArray;
        }
    }
}

