/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.export;

import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class Environment {
    private final String id;
    private final String name;
    private final Type type;

    public Environment(String id, String name, Type type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    @Exported(visibility=3)
    public String getId() {
        return this.id;
    }

    @Exported(visibility=3)
    public String getName() {
        return this.name;
    }

    @Exported(visibility=3)
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.type.name() + " environment " + this.name + " (" + this.id + ")";
    }

    public static enum Type {
        unmapped,
        development,
        testing,
        staging,
        production;


        public static Type fromString(String string) {
            try {
                return Type.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                return unmapped;
            }
        }
    }
}

