// CHECKSTYLE:OFF

package org.marvelution.jji;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code site.not.up.to.date}: {@code The Jira app is not up to
     * date, consider updating it to make sure you are not missing out on new
     * features and critical fixes!}.
     * 
     * @return
     *     {@code The Jira app is not up to date, consider updating it to make
     *     sure you are not missing out on new features and critical fixes!}
     */
    public static String site_not_up_to_date() {
        return holder.format("site.not.up.to.date");
    }

    /**
     * Key {@code site.not.up.to.date}: {@code The Jira app is not up to
     * date, consider updating it to make sure you are not missing out on new
     * features and critical fixes!}.
     * 
     * @return
     *     {@code The Jira app is not up to date, consider updating it to make
     *     sure you are not missing out on new features and critical fixes!}
     */
    public static Localizable _site_not_up_to_date() {
        return new Localizable(holder, "site.not.up.to.date");
    }

    /**
     * Key {@code site.license.issue}: {@code The integration is broken
     * because of a missing or invalid License, check Jira and its apps to
     * verify the required licenses are applied and valid.}.
     * 
     * @return
     *     {@code The integration is broken because of a missing or invalid
     *     License, check Jira and its apps to verify the required licenses are
     *     applied and valid.}
     */
    public static String site_license_issue() {
        return holder.format("site.license.issue");
    }

    /**
     * Key {@code site.license.issue}: {@code The integration is broken
     * because of a missing or invalid License, check Jira and its apps to
     * verify the required licenses are applied and valid.}.
     * 
     * @return
     *     {@code The integration is broken because of a missing or invalid
     *     License, check Jira and its apps to verify the required licenses are
     *     applied and valid.}
     */
    public static Localizable _site_license_issue() {
        return new Localizable(holder, "site.license.issue");
    }

    /**
     * Key {@code deployment.build.marker}: {@code Deployment Build Marker}.
     * 
     * @return
     *     {@code Deployment Build Marker}
     */
    public static String deployment_build_marker() {
        return holder.format("deployment.build.marker");
    }

    /**
     * Key {@code deployment.build.marker}: {@code Deployment Build Marker}.
     * 
     * @return
     *     {@code Deployment Build Marker}
     */
    public static Localizable _deployment_build_marker() {
        return new Localizable(holder, "deployment.build.marker");
    }

    /**
     * Key {@code site.unregister.failed}: {@code Error unregistering site
     * with Jira.}.
     * 
     * @return
     *     {@code Error unregistering site with Jira.}
     */
    public static String site_unregister_failed() {
        return holder.format("site.unregister.failed");
    }

    /**
     * Key {@code site.unregister.failed}: {@code Error unregistering site
     * with Jira.}.
     * 
     * @return
     *     {@code Error unregistering site with Jira.}
     */
    public static Localizable _site_unregister_failed() {
        return new Localizable(holder, "site.unregister.failed");
    }

    /**
     * Key {@code jira.sync}: {@code Sync with Jira}.
     * 
     * @return
     *     {@code Sync with Jira}
     */
    public static String jira_sync() {
        return holder.format("jira.sync");
    }

    /**
     * Key {@code jira.sync}: {@code Sync with Jira}.
     * 
     * @return
     *     {@code Sync with Jira}
     */
    public static Localizable _jira_sync() {
        return new Localizable(holder, "jira.sync");
    }

    /**
     * Key {@code triggered.sync.of}: {@code Triggered synchronization of
     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggered synchronization of {0}.}
     */
    public static String triggered_sync_of(Object arg0) {
        return holder.format("triggered.sync.of", arg0);
    }

    /**
     * Key {@code triggered.sync.of}: {@code Triggered synchronization of
     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggered synchronization of {0}.}
     */
    public static Localizable _triggered_sync_of(Object arg0) {
        return new Localizable(holder, "triggered.sync.of", arg0);
    }

    /**
     * Key {@code site.tunnel.not.connected}: {@code An error occurred
     * connecting to the secure tunnel, see Jenkins logs for details.}.
     * 
     * @return
     *     {@code An error occurred connecting to the secure tunnel, see Jenkins
     *     logs for details.}
     */
    public static String site_tunnel_not_connected() {
        return holder.format("site.tunnel.not.connected");
    }

    /**
     * Key {@code site.tunnel.not.connected}: {@code An error occurred
     * connecting to the secure tunnel, see Jenkins logs for details.}.
     * 
     * @return
     *     {@code An error occurred connecting to the secure tunnel, see Jenkins
     *     logs for details.}
     */
    public static Localizable _site_tunnel_not_connected() {
        return new Localizable(holder, "site.tunnel.not.connected");
    }

    /**
     * Key {@code manage.description}: {@code Manage linked Jira Sites.}.
     * 
     * @return
     *     {@code Manage linked Jira Sites.}
     */
    public static String manage_description() {
        return holder.format("manage.description");
    }

    /**
     * Key {@code manage.description}: {@code Manage linked Jira Sites.}.
     * 
     * @return
     *     {@code Manage linked Jira Sites.}
     */
    public static Localizable _manage_description() {
        return new Localizable(holder, "manage.description");
    }

    /**
     * Key {@code cause.triggered.through}: {@code Started by {0} through
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by {0} through {1}}
     */
    public static String cause_triggered_through(Object arg0, Object arg1) {
        return holder.format("cause.triggered.through", arg0, arg1);
    }

    /**
     * Key {@code cause.triggered.through}: {@code Started by {0} through
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by {0} through {1}}
     */
    public static Localizable _cause_triggered_through(Object arg0, Object arg1) {
        return new Localizable(holder, "cause.triggered.through", arg0, arg1);
    }

    /**
     * Key {@code site.get.url.failed}: {@code Error retrieving Jira url.}.
     * 
     * @return
     *     {@code Error retrieving Jira url.}
     */
    public static String site_get_url_failed() {
        return holder.format("site.get.url.failed");
    }

    /**
     * Key {@code site.get.url.failed}: {@code Error retrieving Jira url.}.
     * 
     * @return
     *     {@code Error retrieving Jira url.}
     */
    public static Localizable _site_get_url_failed() {
        return new Localizable(holder, "site.get.url.failed");
    }

    /**
     * Key {@code cause.triggered.by}: {@code Started by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by {0}}
     */
    public static String cause_triggered_by(Object arg0) {
        return holder.format("cause.triggered.by", arg0);
    }

    /**
     * Key {@code cause.triggered.by}: {@code Started by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by {0}}
     */
    public static Localizable _cause_triggered_by(Object arg0) {
        return new Localizable(holder, "cause.triggered.by", arg0);
    }

    /**
     * Key {@code site.check.failed}: {@code Failed to verify the integration
     * with Jira, check the logs of Jenkins for details.}.
     * 
     * @return
     *     {@code Failed to verify the integration with Jira, check the logs of
     *     Jenkins for details.}
     */
    public static String site_check_failed() {
        return holder.format("site.check.failed");
    }

    /**
     * Key {@code site.check.failed}: {@code Failed to verify the integration
     * with Jira, check the logs of Jenkins for details.}.
     * 
     * @return
     *     {@code Failed to verify the integration with Jira, check the logs of
     *     Jenkins for details.}
     */
    public static Localizable _site_check_failed() {
        return new Localizable(holder, "site.check.failed");
    }

    /**
     * Key {@code maximum.length}: {@code Maximum length of {0} characters.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Maximum length of {0} characters.}
     */
    public static String maximum_length(Object arg0) {
        return holder.format("maximum.length", arg0);
    }

    /**
     * Key {@code maximum.length}: {@code Maximum length of {0} characters.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Maximum length of {0} characters.}
     */
    public static Localizable _maximum_length(Object arg0) {
        return new Localizable(holder, "maximum.length", arg0);
    }

    /**
     * Key {@code unable.to.trigger.sync.of}: {@code Unable to trigger
     * synchronization of {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to trigger synchronization of {0}.}
     */
    public static String unable_to_trigger_sync_of(Object arg0) {
        return holder.format("unable.to.trigger.sync.of", arg0);
    }

    /**
     * Key {@code unable.to.trigger.sync.of}: {@code Unable to trigger
     * synchronization of {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to trigger synchronization of {0}.}
     */
    public static Localizable _unable_to_trigger_sync_of(Object arg0) {
        return new Localizable(holder, "unable.to.trigger.sync.of", arg0);
    }

    /**
     * Key {@code site.not.found}: {@code Site not found, please refresh the
     * page.}.
     * 
     * @return
     *     {@code Site not found, please refresh the page.}
     */
    public static String site_not_found() {
        return holder.format("site.not.found");
    }

    /**
     * Key {@code site.not.found}: {@code Site not found, please refresh the
     * page.}.
     * 
     * @return
     *     {@code Site not found, please refresh the page.}
     */
    public static Localizable _site_not_found() {
        return new Localizable(holder, "site.not.found");
    }

    /**
     * Key {@code no.sites.selected}: {@code No Jira sites to synchronize
     * with.}.
     * 
     * @return
     *     {@code No Jira sites to synchronize with.}
     */
    public static String no_sites_selected() {
        return holder.format("no.sites.selected");
    }

    /**
     * Key {@code no.sites.selected}: {@code No Jira sites to synchronize
     * with.}.
     * 
     * @return
     *     {@code No Jira sites to synchronize with.}
     */
    public static Localizable _no_sites_selected() {
        return new Localizable(holder, "no.sites.selected");
    }

    /**
     * Key {@code site.status.unknown}: {@code Unable to verify the
     * integration status with Jira, check both Jira and Jenkins logs for
     * details.}.
     * 
     * @return
     *     {@code Unable to verify the integration status with Jira, check both
     *     Jira and Jenkins logs for details.}
     */
    public static String site_status_unknown() {
        return holder.format("site.status.unknown");
    }

    /**
     * Key {@code site.status.unknown}: {@code Unable to verify the
     * integration status with Jira, check both Jira and Jenkins logs for
     * details.}.
     * 
     * @return
     *     {@code Unable to verify the integration status with Jira, check both
     *     Jira and Jenkins logs for details.}
     */
    public static Localizable _site_status_unknown() {
        return new Localizable(holder, "site.status.unknown");
    }

    /**
     * Key {@code manage.display.name}: {@code Manage Jira Sites}.
     * 
     * @return
     *     {@code Manage Jira Sites}
     */
    public static String manage_display_name() {
        return holder.format("manage.display.name");
    }

    /**
     * Key {@code manage.display.name}: {@code Manage Jira Sites}.
     * 
     * @return
     *     {@code Manage Jira Sites}
     */
    public static Localizable _manage_display_name() {
        return new Localizable(holder, "manage.display.name");
    }

    /**
     * Key {@code no.whitespaces.allowed}: {@code No white spaces allowed.}.
     * 
     * @return
     *     {@code No white spaces allowed.}
     */
    public static String no_whitespaces_allowed() {
        return holder.format("no.whitespaces.allowed");
    }

    /**
     * Key {@code no.whitespaces.allowed}: {@code No white spaces allowed.}.
     * 
     * @return
     *     {@code No white spaces allowed.}
     */
    public static Localizable _no_whitespaces_allowed() {
        return new Localizable(holder, "no.whitespaces.allowed");
    }

    /**
     * Key {@code site.tunnel.unsatisfied.link.error}: {@code Failed to
     * connect to secure tunnel because of a system requirement issue, see
     * Jenkins logs for details.}.
     * 
     * @return
     *     {@code Failed to connect to secure tunnel because of a system
     *     requirement issue, see Jenkins logs for details.}
     */
    public static String site_tunnel_unsatisfied_link_error() {
        return holder.format("site.tunnel.unsatisfied.link.error");
    }

    /**
     * Key {@code site.tunnel.unsatisfied.link.error}: {@code Failed to
     * connect to secure tunnel because of a system requirement issue, see
     * Jenkins logs for details.}.
     * 
     * @return
     *     {@code Failed to connect to secure tunnel because of a system
     *     requirement issue, see Jenkins logs for details.}
     */
    public static Localizable _site_tunnel_unsatisfied_link_error() {
        return new Localizable(holder, "site.tunnel.unsatisfied.link.error");
    }

    /**
     * Key {@code site.up.and.ready}: {@code All good and ready to go!}.
     * 
     * @return
     *     {@code All good and ready to go!}
     */
    public static String site_up_and_ready() {
        return holder.format("site.up.and.ready");
    }

    /**
     * Key {@code site.up.and.ready}: {@code All good and ready to go!}.
     * 
     * @return
     *     {@code All good and ready to go!}
     */
    public static Localizable _site_up_and_ready() {
        return new Localizable(holder, "site.up.and.ready");
    }

}
