/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import io.jenkins.plugins.insightappsec.BuildAdvanceIndicator;
import io.jenkins.plugins.insightappsec.InsightAppSecLogger;
import io.jenkins.plugins.insightappsec.api.scan.Scan;
import io.jenkins.plugins.insightappsec.api.scan.ScanAction;
import io.jenkins.plugins.insightappsec.api.scan.ScanApi;
import io.jenkins.plugins.insightappsec.exception.DurationExceededException;

public class ScanDurationHandler {
    private final BuildAdvanceIndicator buildAdvanceIndicator;
    private final ScanApi scanApi;
    private final InsightAppSecLogger logger;
    private final Long buildStartTimeMillis;
    private Long scanExecutionStartTimeMillis;
    private final Long maxScanPendingDurationMillis;
    private final Long maxScanExecutionDurationMillis;
    private boolean stopInvoked = false;

    public ScanDurationHandler(BuildAdvanceIndicator buildAdvanceIndicator, ScanApi scanApi, InsightAppSecLogger logger, Long buildStartTimeMillis, Long maxScanPendingDurationMillis, Long maxScanExecutionDurationMillis) {
        this.buildAdvanceIndicator = buildAdvanceIndicator;
        this.scanApi = scanApi;
        this.logger = logger;
        this.buildStartTimeMillis = buildStartTimeMillis;
        this.maxScanPendingDurationMillis = maxScanPendingDurationMillis;
        this.maxScanExecutionDurationMillis = maxScanExecutionDurationMillis;
    }

    void handleMaxScanPendingDuration(String scanId, Scan.ScanStatus scanStatus) {
        if (this.maxScanPendingDurationMillis == null) {
            return;
        }
        if (scanStatus.equals((Object)Scan.ScanStatus.PENDING) && (this.buildAdvanceIndicator.equals((Object)BuildAdvanceIndicator.SCAN_STARTED) || this.buildAdvanceIndicator.equals((Object)BuildAdvanceIndicator.SCAN_COMPLETED) || this.buildAdvanceIndicator.equals((Object)BuildAdvanceIndicator.VULNERABILITY_QUERY)) && this.durationHasBeenExceeded(this.buildStartTimeMillis, this.maxScanPendingDurationMillis)) {
            this.logger.log("Max scan pending duration has been exceeded, cancelling scan");
            this.scanApi.submitScanAction(scanId, new ScanAction(ScanAction.Action.CANCEL));
            throw new DurationExceededException();
        }
    }

    void handleMaxScanExecutionDuration(String scanId, Scan.ScanStatus scanStatus) {
        if (this.maxScanExecutionDurationMillis == null) {
            return;
        }
        if (scanStatus.equals((Object)Scan.ScanStatus.RUNNING) && (this.buildAdvanceIndicator.equals((Object)BuildAdvanceIndicator.SCAN_COMPLETED) || this.buildAdvanceIndicator.equals((Object)BuildAdvanceIndicator.VULNERABILITY_QUERY))) {
            if (this.stopInvoked) {
                return;
            }
            this.initScanStartTimeIfRequired();
            if (this.durationHasBeenExceeded(this.scanExecutionStartTimeMillis, this.maxScanExecutionDurationMillis)) {
                this.logger.log("Max scan execution duration has been exceeded, stopping scan");
                this.scanApi.submitScanAction(scanId, new ScanAction(ScanAction.Action.STOP));
                this.stopInvoked = true;
            }
        }
    }

    private void initScanStartTimeIfRequired() {
        if (this.scanExecutionStartTimeMillis == null) {
            this.scanExecutionStartTimeMillis = System.currentTimeMillis();
        }
    }

    private boolean durationHasBeenExceeded(long initialTime, long duration) {
        return initialTime + duration < System.currentTimeMillis();
    }
}

