/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import io.jenkins.plugins.insightappsec.Messages;
import io.jenkins.plugins.insightappsec.exception.UnrecognizedRegionException;
import java.util.Arrays;

public enum Region {
    US(Messages.selectors_us(), Region.resolveAPIHost("us")),
    US2(Messages.selectors_us2(), Region.resolveAPIHost("us2")),
    US3(Messages.selectors_us3(), Region.resolveAPIHost("us3")),
    CA(Messages.selectors_ca(), Region.resolveAPIHost("ca")),
    EU(Messages.selectors_eu(), Region.resolveAPIHost("eu")),
    AU(Messages.selectors_au(), Region.resolveAPIHost("au")),
    AP(Messages.selectors_ap(), Region.resolveAPIHost("ap"));

    private String displayName;
    private String apiHost;

    private Region(String displayName, String apiHost) {
        this.displayName = displayName;
        this.apiHost = apiHost;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAPIHost() {
        return this.apiHost;
    }

    private static String resolveAPIHost(String prefix) {
        return String.format("%s.api.insight.rapid7.com", prefix);
    }

    public static Region fromString(String value) {
        return Arrays.stream(Region.values()).filter(e -> e.name().equalsIgnoreCase(value)).findAny().orElseThrow(() -> new UnrecognizedRegionException(value));
    }
}

