/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;

public class InsightAppSecLogger {
    private PrintStream printStream;
    private Supplier<String> timestampSupplier = () -> DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now());

    public InsightAppSecLogger(PrintStream printStream) {
        Objects.requireNonNull(printStream, "PrintStream must not be null");
        this.printStream = printStream;
    }

    public InsightAppSecLogger(PrintStream printStream, Supplier<String> timestampSupplier) {
        Objects.requireNonNull(printStream, "PrintStream must not be null");
        Objects.requireNonNull(timestampSupplier, "Supplier must not be null");
        this.printStream = printStream;
        this.timestampSupplier = timestampSupplier;
    }

    public void log(String string) {
        this.log(string, "");
    }

    public void log(String template, Object ... params) {
        this.printStream.println(String.format("[iAS - %s] %s", this.timestampSupplier.get(), String.format(template, params)));
    }
}

