/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.gitea;

import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksStatus;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitState;

class GiteaChecksDetails {
    private final ChecksDetails details;
    private static final int GITEA_MAX_DESCRIPTION_SIZE = 256;

    GiteaChecksDetails(ChecksDetails details) {
        if (details.getConclusion() == ChecksConclusion.NONE) {
            if (details.getStatus() == ChecksStatus.COMPLETED) {
                throw new IllegalArgumentException("No conclusion has been set when status is completed.");
            }
            if (details.getCompletedAt().isPresent()) {
                throw new IllegalArgumentException("No conclusion has been set when \"completedAt\" is provided.");
            }
        }
        this.details = details;
    }

    public String getName() {
        return this.details.getName().filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException("The check name is blank."));
    }

    public String getContextString() {
        return this.getName();
    }

    public GiteaCommitState getStatus() {
        switch (this.details.getStatus()) {
            case NONE: 
            case QUEUED: 
            case IN_PROGRESS: {
                return GiteaCommitState.PENDING;
            }
            case COMPLETED: {
                switch (this.details.getConclusion()) {
                    case NEUTRAL: 
                    case SKIPPED: 
                    case SUCCESS: {
                        return GiteaCommitState.SUCCESS;
                    }
                    case ACTION_REQUIRED: {
                        return GiteaCommitState.WARNING;
                    }
                    case CANCELED: 
                    case FAILURE: {
                        return GiteaCommitState.FAILURE;
                    }
                    case TIME_OUT: {
                        return GiteaCommitState.ERROR;
                    }
                }
                throw new IllegalArgumentException("Unsupported checks status: " + String.valueOf(this.details.getStatus()));
            }
        }
        throw new IllegalArgumentException("Unsupported checks status: " + String.valueOf(this.details.getStatus()));
    }

    public Optional<String> getDetailsURL() {
        if (this.details.getDetailsURL().filter(StringUtils::isBlank).isPresent()) {
            return Optional.empty();
        }
        this.details.getDetailsURL().ifPresent(url -> {
            if (!StringUtils.equalsAny((CharSequence)URI.create(url).getScheme(), (CharSequence[])new CharSequence[]{"http", "https"})) {
                throw new IllegalArgumentException("The details url is not http or https scheme: " + url);
            }
        });
        return this.details.getDetailsURL();
    }

    public Optional<String> getDescription() {
        if (this.details.getOutput().isPresent()) {
            return ((ChecksOutput)this.details.getOutput().get()).getSummary(256);
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<Date> getStartedAt() {
        if (this.details.getStartedAt().isPresent()) {
            return Optional.of(Date.from(((LocalDateTime)this.details.getStartedAt().get()).toInstant(ZoneOffset.UTC)));
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<Date> getCompletedAt() {
        if (this.details.getCompletedAt().isPresent()) {
            return Optional.of(Date.from(((LocalDateTime)this.details.getCompletedAt().get()).toInstant(ZoneOffset.UTC)));
        }
        return Optional.empty();
    }
}

