/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event.transformer;

import io.jenkins.plugins.generic.event.Event;
import io.jenkins.plugins.generic.event.data.WorkflowRunData;
import io.jenkins.plugins.generic.event.transformer.EventDataTransformer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jodah.typetools.TypeResolver;

public enum EventDataTransformers {
    INSTANCE;

    private final Map<Type, EventDataTransformer<?>> transformers = new HashMap();

    private EventDataTransformers() {
        this.register(WorkflowRunData::new);
    }

    public void register(EventDataTransformer<?> transformer) {
        this.transformers.put(this.getActualArgumentType(transformer), transformer);
    }

    public void unregister(EventDataTransformer<?> transformer) {
        this.transformers.remove(this.getActualArgumentType(transformer), transformer);
    }

    public Collection<EventDataTransformer<?>> getAllTransformers() {
        return Collections.unmodifiableCollection(this.transformers.values());
    }

    public void transform(Event event) {
        if (event == null || event.getData() == null) {
            return;
        }
        EventDataTransformer<?> transformer = this.transformers.get(event.getData().getClass());
        if (transformer == null) {
            return;
        }
        Object transformedData = transformer.transform(event.getData());
        event.setData(transformedData);
    }

    private Type getActualArgumentType(EventDataTransformer<?> transformer) {
        return TypeResolver.resolveRawArgument(EventDataTransformer.class, transformer.getClass());
    }
}

