/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event.listener;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import io.jenkins.plugins.generic.event.Event;
import io.jenkins.plugins.generic.event.EventGlobalConfiguration;
import io.jenkins.plugins.generic.event.EventSender;
import io.jenkins.plugins.generic.event.HttpEventSender;
import io.jenkins.plugins.generic.event.MetaData;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;

@Extension
public class GenericEventItemListener
extends ItemListener {
    private EventSender eventSender;

    public GenericEventItemListener() {
        this.setEventSender(new HttpEventSender());
    }

    public void setEventSender(EventSender eventSender) {
        this.eventSender = eventSender;
    }

    public String getCanonicalEventUrl(String fullName) {
        StringBuilder resultUrl = new StringBuilder();
        if (Stapler.getCurrentRequest2() == null) {
            return "";
        }
        List ancs = Stapler.getCurrentRequest2().getAncestors();
        for (Ancestor anc : ancs) {
            Object o;
            String uri;
            if (anc.equals(ancs.get(ancs.size() - 1)) && ((uri = Stapler.getCurrentRequest2().getOriginalRequestURI()).endsWith("confirmRename") || uri.endsWith("configSubmit")) || !((o = anc.getObject()) instanceof Folder)) continue;
            String urlToAdd = ((Folder)o).getName();
            resultUrl.append("job/");
            resultUrl.append(Util.rawEncode((String)urlToAdd));
            resultUrl.append("/");
        }
        String entityName = fullName.substring(fullName.lastIndexOf(47) + 1);
        resultUrl.append("job/");
        resultUrl.append(Util.rawEncode((String)entityName));
        resultUrl.append("/");
        return resultUrl.toString();
    }

    public String getCanonicalEventUrlNewLocation(Item item, String newFullName) {
        String jobName = newFullName.substring(newFullName.lastIndexOf(47) + 1);
        ArrayList<String> urls_list = new ArrayList<String>();
        AbstractItem _item = (AbstractItem)item;
        while (_item.getParent() != null && !(_item.getParent() instanceof Hudson)) {
            String _url = ((AbstractItem)_item.getParent()).getShortUrl();
            urls_list.add(0, _url);
            _item = (AbstractItem)_item.getParent();
        }
        return String.join((CharSequence)"", urls_list) + item.getParent().getUrlChildPrefix() + "/" + Util.rawEncode((String)jobName) + "/";
    }

    public void onCreated(Item item) {
        EventGlobalConfiguration config = EventGlobalConfiguration.get();
        if (config != null && config.isSendItemCreated() && config.matchesJobNamePattern(item.getFullName())) {
            this.eventSender.send(new Event.EventBuilder().type("item.created").source(item.getParent().getUrl()).url(this.getCanonicalEventUrl(item.getName())).data(item).build());
        }
    }

    public void onDeleted(Item item) {
        EventGlobalConfiguration config = EventGlobalConfiguration.get();
        if (config != null && config.isSendItemDeleted() && config.matchesJobNamePattern(item.getFullName())) {
            this.eventSender.send(new Event.EventBuilder().type("item.deleted").source(item.getParent().getUrl()).url(this.getCanonicalEventUrl(item.getName())).data(item).build());
        }
    }

    public void onUpdated(Item item) {
        EventGlobalConfiguration config = EventGlobalConfiguration.get();
        if (config != null && config.isSendItemUpdated() && config.matchesJobNamePattern(item.getFullName())) {
            this.eventSender.send(new Event.EventBuilder().type("item.updated").source(item.getParent().getUrl()).url(this.getCanonicalEventUrl(item.getName())).data(item).build());
        }
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        EventGlobalConfiguration config = EventGlobalConfiguration.get();
        if (config != null && config.isSendItemLocationChanged() && config.matchesJobNamePattern(newFullName)) {
            this.eventSender.send(new Event.EventBuilder().type("item.locationChanged").source(item.getParent().getUrl()).data(item).metaData(new MetaData.MetaDataBuilder().oldName(oldFullName).newName(newFullName).oldUrl(this.getCanonicalEventUrl(oldFullName)).newUrl(this.getCanonicalEventUrlNewLocation(item, newFullName)).build()).build());
        }
    }
}

