/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.explain_error.AIProvider;
import io.jenkins.plugins.explain_error.AIService;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ErrorExplainer {
    private static final Logger LOGGER = Logger.getLogger(ErrorExplainer.class.getName());

    public void explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines) {
        String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
        try {
            GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
            if (!config.isEnableExplanation()) {
                listener.getLogger().println("AI error explanation is disabled in global configuration.");
                return;
            }
            if (config.getProvider() != AIProvider.OLLAMA && (config.getApiKey() == null || StringUtils.isBlank((CharSequence)config.getApiKey().getPlainText()))) {
                listener.getLogger().println("ERROR: API key is not configured. Please configure it in Jenkins global settings.");
                return;
            }
            String errorLogs = this.extractErrorLogs(run, logPattern, maxLines);
            if (StringUtils.isBlank((CharSequence)errorLogs)) {
                listener.getLogger().println("No error logs found to explain.");
                return;
            }
            AIService aiService = new AIService(config);
            String explanation = aiService.explainError(errorLogs);
            LOGGER.info(jobInfo + " AI error explanation succeeded.");
            ErrorExplanationAction action = new ErrorExplanationAction(explanation, errorLogs);
            run.addOrReplaceAction((Action)action);
        }
        catch (Exception e) {
            LOGGER.severe(jobInfo + " Failed to explain error: " + e.getMessage());
            listener.getLogger().println(jobInfo + " Failed to explain error: " + e.getMessage());
        }
    }

    private String extractErrorLogs(Run<?, ?> run, String logPattern, int maxLines) throws IOException {
        List logLines = run.getLog(maxLines);
        if (StringUtils.isBlank((CharSequence)logPattern)) {
            return String.join((CharSequence)"\n", logLines);
        }
        Pattern pattern = Pattern.compile(logPattern, 2);
        StringBuilder errorLogs = new StringBuilder();
        for (String line : logLines) {
            if (!pattern.matcher(line).find()) continue;
            errorLogs.append(line).append("\n");
        }
        return errorLogs.toString();
    }

    public String explainErrorText(String errorText, Run<?, ?> run) {
        String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
        try {
            GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
            if (!config.isEnableExplanation()) {
                LOGGER.warning("AI error explanation is disabled in global configuration");
                return "AI error explanation is disabled in global configuration.";
            }
            if (config.getProvider() != AIProvider.OLLAMA && (config.getApiKey() == null || StringUtils.isBlank((CharSequence)config.getApiKey().getPlainText()))) {
                LOGGER.warning("API key is not configured");
                return "ERROR: API key is not configured. Please configure it in Jenkins global settings.";
            }
            if (StringUtils.isBlank((CharSequence)errorText)) {
                LOGGER.warning("No error text provided");
                return "No error text provided to explain.";
            }
            AIService aiService = new AIService(config);
            String explanation = aiService.explainError(errorText);
            LOGGER.info(jobInfo + " AI error explanation succeeded.");
            LOGGER.fine("Explanation length: " + (explanation != null ? explanation.length() : 0));
            return explanation;
        }
        catch (Exception e) {
            LOGGER.severe(jobInfo + " Failed to explain error text: " + e.getMessage());
            e.printStackTrace();
            return "Failed to explain error: " + e.getMessage();
        }
    }
}

