/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import io.jenkins.plugins.explain_error.AIProvider;
import io.jenkins.plugins.explain_error.BaseAIService;
import io.jenkins.plugins.explain_error.GeminiService;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import io.jenkins.plugins.explain_error.OllamaService;
import io.jenkins.plugins.explain_error.OpenAIService;
import java.io.IOException;
import java.util.logging.Logger;

public class AIService {
    private static final Logger LOGGER = Logger.getLogger(AIService.class.getName());
    private final BaseAIService delegate;

    public AIService(GlobalConfigurationImpl config) {
        this.delegate = this.createServiceForProvider(config);
    }

    private BaseAIService createServiceForProvider(GlobalConfigurationImpl config) {
        AIProvider provider = config.getProvider();
        switch (provider) {
            case OPENAI: {
                return new OpenAIService(config);
            }
            case GEMINI: {
                return new GeminiService(config);
            }
            case OLLAMA: {
                return new OllamaService(config);
            }
        }
        LOGGER.warning("Unknown AI provider: " + String.valueOf((Object)provider) + ". Defaulting to OpenAI.");
        return new OpenAIService(config);
    }

    public String explainError(String errorLogs) throws IOException {
        return this.delegate.explainError(errorLogs);
    }
}

