/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.emergencystop;

import hudson.Extension;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.RootAction;
import hudson.model.Run;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension
public class SimpleEmergencyStopAction
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(SimpleEmergencyStopAction.class.getName());
    private int stoppedPipelines;
    private int notStoppedPipelines;

    public int getStoppedPipelines() {
        return this.stoppedPipelines;
    }

    public int getNotStoppedPipelines() {
        return this.notStoppedPipelines;
    }

    public String getIconFileName() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.hasPermission(Jenkins.ADMINISTER) ? "symbol-warning" : null;
    }

    public String getDisplayName() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.hasPermission(Jenkins.ADMINISTER) ? "Emergency STOP Pipelines" : null;
    }

    public String getUrlName() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.hasPermission(Jenkins.ADMINISTER) ? "emergency-stop-pipelines" : null;
    }

    @POST
    public void doStop(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
            rsp.sendError(403, "You need ADMIN permission to perform this action");
            return;
        }
        this.stoppedPipelines = 0;
        this.notStoppedPipelines = 0;
        try {
            List allJobs = jenkins.getAllItems(Job.class);
            for (Job job : allJobs) {
                for (Run build : job.getBuilds()) {
                    if (!build.isBuilding()) continue;
                    Executor executor = build.getExecutor();
                    if (executor != null) {
                        executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{new CauseOfInterruption.UserInterruption("EMERGENCY STOP by " + Jenkins.getAuthentication2().getName())});
                        ++this.stoppedPipelines;
                        continue;
                    }
                    LOGGER.warning("Cannot stop build (no executor): " + build.getFullDisplayName());
                    ++this.notStoppedPipelines;
                }
            }
            Queue queue = jenkins.getQueue();
            for (Queue.Item item : queue.getItems()) {
                boolean cancelled = queue.cancel(item);
                if (cancelled) {
                    ++this.stoppedPipelines;
                    continue;
                }
                LOGGER.warning("Failed to cancel queued item: " + item.task.getFullDisplayName());
                ++this.notStoppedPipelines;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Error during emergency stop: " + e.getMessage());
            rsp.sendError(500, "Error during emergency stop: " + e.getMessage());
            return;
        }
        rsp.setContentType("text/html");
        req.setAttribute("stoppedPipelines", (Object)this.stoppedPipelines);
        req.setAttribute("notStoppedPipelines", (Object)this.notStoppedPipelines);
        req.getView((Object)this, "success.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }
}

