/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.emergencystop;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import jakarta.servlet.ServletException;
import java.io.IOException;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.GET;

public class EmergencyFolderStopAction
implements Action {
    private final Folder folder;

    public EmergencyFolderStopAction(Folder folder) {
        this.folder = folder;
    }

    public String getIconFileName() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.hasPermission(Jenkins.ADMINISTER) ? "symbol-warning" : null;
    }

    public String getDisplayName() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.hasPermission(Jenkins.ADMINISTER) ? "Emerg. Stop Folder Pipelines" : null;
    }

    public String getUrlName() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.hasPermission(Jenkins.ADMINISTER) ? "emergency-stop-folder-pipelines" : null;
    }

    @GET
    public void doStop(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
            rsp.sendError(403, "You need ADMIN permission to perform this action");
            return;
        }
        if (!"GET".equals(req.getMethod())) {
            rsp.sendError(405, "GET required");
            return;
        }
        try {
            this.stopFolderRecursively((AbstractFolder<?>)this.folder);
        }
        catch (Exception e) {
            rsp.sendError(500, "Error during emergency stop: " + e.getMessage());
            return;
        }
        rsp.setStatus(200);
    }

    private void stopFolderRecursively(AbstractFolder<?> currentFolder) {
        for (TopLevelItem item : currentFolder.getItems()) {
            if (item instanceof Job) {
                Job job = (Job)item;
                for (Run build : job.getBuilds()) {
                    Executor executor;
                    if (!build.isBuilding() || (executor = build.getExecutor()) == null) continue;
                    executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{new CauseOfInterruption.UserInterruption("EMERGENCY STOP by " + Jenkins.getAuthentication2().getName())});
                }
                continue;
            }
            if (!(item instanceof AbstractFolder)) continue;
            AbstractFolder subFolder = (AbstractFolder)item;
            this.stopFolderRecursively(subFolder);
        }
        Queue queue = Jenkins.get().getQueue();
        for (Queue.Item item : queue.getItems()) {
            Job job;
            Queue.Task task = item.task;
            if (!(task instanceof Job) || (job = (Job)task).getParent() != currentFolder) continue;
            queue.cancel(item);
        }
    }
}

