/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header.color;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class HeaderColor
extends AbstractDescribableImpl<HeaderColor> {
    private final String backgroundColor;
    private final String hoverColor;
    private final String color;

    @DataBoundConstructor
    public HeaderColor(String backgroundColor, String hoverColor, String color) {
        this.backgroundColor = backgroundColor;
        this.hoverColor = hoverColor;
        this.color = color;
    }

    public HeaderColor(HeaderColor headerColor) {
        this.backgroundColor = headerColor.getBackgroundColor();
        this.color = headerColor.getColor();
        this.hoverColor = headerColor.getHoverColor();
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getHoverColor() {
        return this.hoverColor;
    }

    public String getColor() {
        return this.color;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HeaderColor> {
        @NonNull
        public String getDisplayName() {
            return "Color";
        }
    }
}

