/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.CustomHeaderConfiguration;
import io.jenkins.plugins.customizable_header.color.HeaderColor;
import io.jenkins.plugins.customizable_header.headers.HeaderSelector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class UserHeader
extends UserProperty {
    private boolean overwriteHeader;
    private boolean overwriteColors;
    private HeaderColor headerColor;
    private HeaderSelector headerSelector;
    private List<AbstractLink> links = new ArrayList<AbstractLink>();
    private Set<String> dismissedMessages = new HashSet<String>();

    @DataBoundConstructor
    public UserHeader() {
    }

    public boolean isOverwriteColors() {
        return this.overwriteColors;
    }

    @DataBoundSetter
    public void setOverwriteColors(boolean overwriteColors) {
        this.overwriteColors = overwriteColors;
    }

    @DataBoundSetter
    public void setHeaderColor(HeaderColor headerColor) {
        this.headerColor = headerColor;
    }

    @DataBoundSetter
    public void setHeaderSelector(HeaderSelector headerSelector) {
        this.headerSelector = headerSelector;
    }

    public HeaderColor getHeaderColor() {
        return this.headerColor;
    }

    public HeaderSelector getHeaderSelector() {
        return this.headerSelector;
    }

    @DataBoundSetter
    public void setOverwriteHeader(boolean overwriteHeader) {
        this.overwriteHeader = overwriteHeader;
    }

    public boolean isOverwriteHeader() {
        return this.overwriteHeader;
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    @DataBoundSetter
    public void setLinks(List<AbstractLink> links) {
        this.links = links;
    }

    public Object readResolve() {
        if (this.dismissedMessages == null) {
            this.dismissedMessages = new HashSet<String>();
        }
        return this;
    }

    public Set<String> getDismissedMessages() {
        return this.dismissedMessages;
    }

    public UserProperty reconfigure(StaplerRequest req, @CheckForNull JSONObject form) {
        if (this.links != null) {
            this.links.clear();
        }
        req.bindJSON((Object)this, form);
        return this;
    }

    @Extension
    @Symbol(value={"customHeader"})
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        public UserProperty newInstance(User user) {
            UserHeader userHeader = new UserHeader();
            HeaderColor globalHeaderColor = CustomHeaderConfiguration.get().getHeaderColor();
            userHeader.setHeaderColor(new HeaderColor(globalHeaderColor));
            return userHeader;
        }

        public boolean isEnabled() {
            return CustomHeaderConfiguration.get().isEnabled();
        }

        @NonNull
        public String getDisplayName() {
            return "Customizable Header";
        }

        @CheckForNull
        public String getUserPropertyCategoryAsString() {
            return "appearance";
        }
    }
}

