/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.model.User;
import hudson.model.UserProperty;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.AppNavLink;
import io.jenkins.plugins.customizable_header.CustomHeaderConfiguration;
import io.jenkins.plugins.customizable_header.LinkSeparator;
import io.jenkins.plugins.customizable_header.SystemMessage;
import io.jenkins.plugins.customizable_header.UserHeader;
import io.jenkins.plugins.customizable_header.headers.LogoSelector;
import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

@Extension
public class HeaderRootAction
implements UnprotectedRootAction {
    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "customizable-header";
    }

    public String getBackgroundColor() {
        return CustomHeaderConfiguration.get().getActiveHeaderColor().getBackgroundColor();
    }

    public String getHoverColor() {
        return CustomHeaderConfiguration.get().getActiveHeaderColor().getHoverColor();
    }

    public String getColor() {
        return CustomHeaderConfiguration.get().getActiveHeaderColor().getColor();
    }

    public boolean isThinHeader() {
        return CustomHeaderConfiguration.get().isThinHeader() && CustomHeaderConfiguration.get().getHeader() instanceof LogoSelector;
    }

    public boolean hasLinks() {
        return CustomHeaderConfiguration.get().hasLinks();
    }

    @POST
    public HttpResponse doAddSystemMessage(@QueryParameter(fixEmpty=true) String message, @QueryParameter(fixEmpty=true) String level, @QueryParameter String expireDate, @QueryParameter(fixEmpty=true) String id) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (message == null || level == null) {
            throw HttpResponses.error((int)400, (String)"Missing parameters: message and level are mandatory");
        }
        try {
            SystemMessage.SystemMessageColor lvl = SystemMessage.SystemMessageColor.valueOf(level);
            SystemMessage msg = new SystemMessage(message, lvl, id);
            msg.setExpireDate(expireDate);
            CustomHeaderConfiguration config = CustomHeaderConfiguration.get();
            config.addSystemMessage(msg);
            return HttpResponses.text((String)msg.getUid());
        }
        catch (DateTimeParseException e) {
            throw HttpResponses.error((int)400, (String)("expireDate is not properly formatted: " + expireDate));
        }
        catch (IllegalArgumentException e) {
            throw HttpResponses.error((int)400, (String)("Unknown level: " + level));
        }
    }

    @POST
    public void doDeleteSystemMessage(@QueryParameter(fixEmpty=true) String id) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (id == null) {
            throw HttpResponses.error((int)400, (String)"Missing parameters: id is mandatory");
        }
        CustomHeaderConfiguration config = CustomHeaderConfiguration.get();
        config.deleteSystemMessage(id);
    }

    @POST
    public void doDismissMessage(@QueryParameter String uid) throws IOException {
        User user = User.current();
        if (user != null) {
            UserHeader userHeader = (UserHeader)user.getProperty(UserHeader.class);
            if (userHeader == null) {
                userHeader = new UserHeader();
                user.addProperty((UserProperty)userHeader);
            }
            userHeader.getDismissedMessages().add(uid);
            user.save();
        }
    }

    @GET
    public Links doGetLinks() throws Exception {
        return new Links();
    }

    @ExportedBean
    static class Links
    implements HttpResponse {
        Links() {
        }

        @Exported(inline=true)
        public List<AbstractLink> getLinks() {
            List<AppNavLink> favorites;
            ArrayList<AbstractLink> links = new ArrayList<AbstractLink>(CustomHeaderConfiguration.get().getLinks());
            List<AbstractLink> userLinks = CustomHeaderConfiguration.get().getUserLinks();
            if (!userLinks.isEmpty()) {
                if (!(userLinks.get(0) instanceof LinkSeparator)) {
                    links.add(new LinkSeparator());
                }
                links.addAll(userLinks);
            }
            if (!(favorites = CustomHeaderConfiguration.get().getFavorites()).isEmpty()) {
                links.add(new LinkSeparator());
                links.addAll(favorites);
            }
            return links;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object o) throws IOException, ServletException {
            rsp.serveExposedBean(req, (Object)this, new ExportConfig().withFlavor(Flavor.JSON));
        }
    }
}

