/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.AppNavLink;
import io.jenkins.plugins.customizable_header.SystemMessage;
import io.jenkins.plugins.customizable_header.UserHeader;
import io.jenkins.plugins.customizable_header.color.HeaderColor;
import io.jenkins.plugins.customizable_header.headers.HeaderSelector;
import io.jenkins.plugins.customizable_header.headers.JenkinsHeaderSelector;
import io.jenkins.plugins.customizable_header.logo.Icon;
import io.jenkins.plugins.customizable_header.logo.Logo;
import io.jenkins.plugins.customizable_header.logo.LogoDescriptor;
import io.jenkins.plugins.customizable_header.logo.Symbol;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@org.jenkinsci.Symbol(value={"customHeader"})
public class CustomHeaderConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(CustomHeaderConfiguration.class.getName());
    private String title = "";
    private String cssResource;
    private String logoText = "Jenkins";
    private Logo logo = new Symbol("symbol-jenkins");
    private HeaderSelector header = new JenkinsHeaderSelector();
    private boolean enabled = true;
    private transient String cssResourceUrl;
    private HeaderColor headerColor = new HeaderColor("black", "grey", "white");
    private boolean thinHeader;
    private transient SystemMessage systemMessage;
    private final List<SystemMessage> systemMessages = new ArrayList<SystemMessage>();
    private List<AbstractLink> links = new ArrayList<AbstractLink>();
    private static final transient Symbol star = new Symbol("symbol-star plugin-ionicons-api");

    @DataBoundConstructor
    public CustomHeaderConfiguration() {
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        boolean result = false;
        try (BulkChange bc = new BulkChange((Saveable)this);){
            this.links.clear();
            List<SystemMessage> list = this.systemMessages;
            synchronized (list) {
                this.systemMessages.clear();
                result = super.configure(req, json);
            }
            bc.commit();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
        return result;
    }

    public Object readResolve() {
        if (this.systemMessage != null) {
            this.systemMessages.add(this.systemMessage);
        }
        return this;
    }

    private static List<AppNavLink> getFavorites(User user) {
        String rootUrl = Jenkins.get().getRootUrl();
        Iterable items = Favorites.getFavorites((User)user);
        ArrayList<AppNavLink> favorites = new ArrayList<AppNavLink>();
        items.forEach(item -> {
            AppNavLink fav = new AppNavLink(rootUrl + item.getUrl(), item.getFullDisplayName(), star);
            fav.setColor("jenkins-!-color-yellow");
            favorites.add(fav);
        });
        favorites.sort(new Comparator<AppNavLink>(){

            @Override
            public int compare(AppNavLink o1, AppNavLink o2) {
                int labelCompare = o1.getLabel().compareToIgnoreCase(o2.getLabel());
                if (labelCompare != 0) {
                    return labelCompare;
                }
                return o1.getUrl().compareTo(o2.getUrl());
            }
        });
        return favorites;
    }

    public List<AppNavLink> getFavorites() {
        User user;
        if (Jenkins.get().getPlugin("favorite") != null && (user = User.current()) != null) {
            return CustomHeaderConfiguration.getFavorites(user);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public SystemMessage getSystemMessage() {
        return this.systemMessage;
    }

    @Deprecated
    @DataBoundSetter
    public void setSystemMessage(SystemMessage systemMessage) {
        this.systemMessage = systemMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SystemMessage> getSystemMessages() {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            UserHeader userHeader;
            Set currentUids = this.systemMessages.stream().map(SystemMessage::getUid).collect(Collectors.toSet());
            User user = User.current();
            if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.getDismissedMessages().removeIf(dismissedUid -> !currentUids.contains(dismissedUid))) {
                try {
                    user.save();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to save user properties", e);
                }
            }
            if (this.systemMessages.removeIf(sm -> sm.isExpired() || sm.getMessage() == null)) {
                this.save();
            }
        }
        return Collections.unmodifiableList(this.systemMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DataBoundSetter
    public void setSystemMessages(List<SystemMessage> systemMessages) {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            this.systemMessages.clear();
            this.systemMessages.addAll(systemMessages);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemMessage(SystemMessage message) {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            this.systemMessages.add(message);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSystemMessage(String id) {
        List<SystemMessage> list = this.systemMessages;
        synchronized (list) {
            this.systemMessages.removeIf(sm -> sm.getUid().equals(id));
        }
        this.save();
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    @DataBoundSetter
    public void setLinks(List<AbstractLink> links) {
        this.links = links;
        this.save();
    }

    private boolean hasFavorites() {
        User user;
        if (Jenkins.get().getPlugin("favorite") != null && (user = User.current()) != null) {
            Iterable items = Favorites.getFavorites((User)user);
            return items.iterator().hasNext();
        }
        return false;
    }

    private boolean hasAppLinks() {
        if (this.links == null) {
            return false;
        }
        return this.links.size() != 0;
    }

    private boolean hasUserLinks() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null) {
            return userHeader.getLinks() != null && userHeader.getLinks().size() != 0;
        }
        return false;
    }

    public boolean hasLinks() {
        return this.hasFavorites() || this.hasAppLinks() || this.hasUserLinks();
    }

    public List<AbstractLink> getUserLinks() {
        UserHeader userHeader;
        User user = User.current();
        List<AbstractLink> links = null;
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null) {
            links = userHeader.getLinks();
        }
        if (links != null) {
            return links;
        }
        return Collections.emptyList();
    }

    public boolean isThinHeader() {
        return this.thinHeader;
    }

    @DataBoundSetter
    public void setThinHeader(boolean thinHeader) {
        this.thinHeader = thinHeader;
        this.save();
    }

    @DataBoundSetter
    public void setHeader(HeaderSelector header) {
        this.header = header;
        this.save();
    }

    public HeaderSelector getHeader() {
        return this.header;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @DataBoundSetter
    public void setLogo(Logo logo) {
        this.logo = logo;
        this.save();
    }

    public Logo getLogo() {
        return this.logo;
    }

    @DataBoundSetter
    public void setHeaderColor(HeaderColor headerColor) {
        this.headerColor = headerColor;
        this.save();
    }

    public HeaderColor getHeaderColor() {
        return this.headerColor;
    }

    public HeaderColor getActiveHeaderColor() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.isOverwriteColors()) {
            return userHeader.getHeaderColor();
        }
        return this.headerColor;
    }

    public HeaderSelector getActiveHeader() {
        if (this.enabled) {
            UserHeader userHeader;
            User user = User.current();
            if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null && userHeader.isOverwriteHeader()) {
                return userHeader.getHeaderSelector();
            }
            return this.header;
        }
        return new JenkinsHeaderSelector();
    }

    @DataBoundSetter
    public void setLogoText(String logoText) {
        this.logoText = logoText;
        this.save();
    }

    public String getLogoText() {
        return this.logoText;
    }

    public static CustomHeaderConfiguration get() {
        return (CustomHeaderConfiguration)((Object)GlobalConfiguration.all().get(CustomHeaderConfiguration.class));
    }

    public String getTitle() {
        return this.title;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
        this.save();
    }

    public String getCssResource() {
        return Util.fixEmptyAndTrim((String)this.cssResource);
    }

    @DataBoundSetter
    public void setCssResource(String cssResource) {
        this.cssResource = cssResource;
        this.setCssResourceUrl();
        this.save();
    }

    private void setCssResourceUrl() {
        block5: {
            if (Util.fixEmptyAndTrim((String)this.cssResource) != null) {
                try {
                    URI uri = URI.create(this.cssResource);
                    if (uri.isAbsolute()) {
                        this.cssResourceUrl = this.cssResource;
                        break block5;
                    }
                    this.cssResourceUrl = Jenkins.get().getRootUrl() + this.cssResource;
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.log(Level.WARNING, "The given css resource is not a valid uri", iae);
                    this.cssResourceUrl = "";
                }
            } else {
                this.cssResourceUrl = "";
            }
        }
    }

    public String getCssResourceUrl() {
        if (this.cssResourceUrl == null) {
            this.setCssResourceUrl();
        }
        return this.cssResourceUrl;
    }

    public Logo defaultLogo() {
        return new Symbol("symbol-jenkins");
    }

    public List<Descriptor<Logo>> getLogoDescriptors() {
        return LogoDescriptor.all().stream().filter(d -> !(d instanceof Icon.DescriptorImpl)).collect(Collectors.toList());
    }
}

