/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds.utils;

import com.crowdstrike.plugins.crwds.FalconContext;
import com.crowdstrike.plugins.crwds.utils.ProcessCodes;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class DockerUtils {
    private final ContainerRuntime runtime;

    public DockerUtils() {
        this(ContainerRuntime.DOCKER);
    }

    public DockerUtils(ContainerRuntime runtime) {
        this.runtime = runtime;
    }

    public static boolean isRuntimeAvailable(ContainerRuntime runtime, EnvVars env, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(runtime.getExecutable()).add("--version");
            int exitCode = launcher.launch().cmds(args).envs((Map)env).stdout(listener).pwd(workspace).join();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public Integer containerLogin(FalconContext context, String username, String password, String csRegistryUrl) {
        context.getLogger().println("[CRWDS::DEBUG] === Container Login Debug ===");
        context.getLogger().println("[CRWDS::DEBUG] Runtime executable: " + this.runtime.getExecutable());
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.runtime.getExecutable());
        args.add(new String[]{"login", "--username", username, "--password-stdin"}).add(csRegistryUrl);
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(password.getBytes(StandardCharsets.UTF_8));
            if (DockerUtils.launchProcess(context, args, input) != 0) {
                String errorMsg = this.runtime == ContainerRuntime.DOCKER ? "[ABORT] Docker Login - " + ProcessCodes.DOCKER_LOGIN_FAILURE.getDescription() : "[ABORT] Podman Login - " + ProcessCodes.PODMAN_LOGIN_FAILURE.getDescription();
                throw new AbortException(errorMsg);
            }
        }
        catch (IOException | InterruptedException ex) {
            context.getLogger().println("[CRWDS::DEBUG] " + this.runtime.getExecutable() + " Login -" + ex.getMessage());
            return this.runtime == ContainerRuntime.DOCKER ? ProcessCodes.DOCKER_LOGIN_FAILURE.getCode() : ProcessCodes.PODMAN_LOGIN_FAILURE.getCode();
        }
        context.getLogger().println("[CRWDS::DEBUG] " + this.runtime.getExecutable() + " Login -" + ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getDescription());
        return ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getCode();
    }

    public Integer containerPush(FalconContext context, String csRegistryUrl, String imageName, String imageTag) {
        csRegistryUrl = csRegistryUrl.replace("https://", "");
        String imageNameTagOnRegistry = csRegistryUrl + "/" + imageName + ":" + imageTag;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.runtime.getExecutable()).add("push").add(imageNameTagOnRegistry);
        try {
            Integer containerTagStatus = this.containerTag(context, csRegistryUrl, imageName, imageTag);
            if (containerTagStatus.intValue() != ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getCode()) {
                return containerTagStatus;
            }
            if (DockerUtils.launchProcess(context, args, null) != 0) {
                String errorMsg = this.runtime == ContainerRuntime.DOCKER ? ProcessCodes.DOCKER_PUSH_FAILURE.getDescription() : ProcessCodes.PODMAN_PUSH_FAILURE.getDescription();
                throw new AbortException(errorMsg);
            }
        }
        catch (IOException | InterruptedException ex) {
            context.getLogger().println("[CRWDS::DEBUG] " + this.runtime.getExecutable() + " Push -" + ex.getMessage());
            return this.runtime == ContainerRuntime.DOCKER ? ProcessCodes.DOCKER_PUSH_FAILURE.getCode() : ProcessCodes.PODMAN_PUSH_FAILURE.getCode();
        }
        context.getLogger().println("[CRWDS::DEBUG] " + this.runtime.getExecutable() + " Push -" + ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getDescription());
        return ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getCode();
    }

    public Integer containerTag(FalconContext context, String csRegistryUrl, String imageName, String imageTag) {
        String imageNameTag = imageName + ":" + imageTag;
        String imageNameTagOnRegistry = csRegistryUrl + "/" + imageNameTag;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.runtime.getExecutable()).add("tag").add(imageNameTag).add(imageNameTagOnRegistry);
        try {
            if (DockerUtils.launchProcess(context, args, null) != 0) {
                String errorMsg = this.runtime == ContainerRuntime.DOCKER ? "[ABORT] Docker Tag - " + ProcessCodes.DOCKER_TAG_FAILURE.getDescription() : "[ABORT] Podman Tag - " + ProcessCodes.PODMAN_TAG_FAILURE.getDescription();
                throw new AbortException(errorMsg);
            }
        }
        catch (IOException | InterruptedException ex) {
            context.getLogger().println("[CRWDS::DEBUG] " + this.runtime.getExecutable() + " Tag -" + ex.getMessage());
            return this.runtime == ContainerRuntime.DOCKER ? ProcessCodes.DOCKER_TAG_FAILURE.getCode() : ProcessCodes.PODMAN_TAG_FAILURE.getCode();
        }
        context.getLogger().println("[CRWDS::DEBUG] " + this.runtime.getExecutable() + " Tag -" + ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getDescription());
        return ProcessCodes.CONTAINER_RUNTIME_OPERATION_SUCCESS.getCode();
    }

    private static int launchProcess(FalconContext context, ArgumentListBuilder cmds, InputStream input) throws IOException, InterruptedException {
        Launcher.ProcStarter ps = new Launcher.ProcStarter(context.getLauncher());
        ps = ps.cmds(cmds).stdout(context.getTaskListener());
        ps = ps.pwd(context.getWorkspace()).envs((Map)context.getEnvVars());
        if (input != null) {
            ps = ps.stdin(input);
        }
        Proc proc = context.getLauncher().launch(ps);
        return proc.join();
    }

    public ContainerRuntime getRuntime() {
        return this.runtime;
    }

    public String getRuntimeName() {
        return this.runtime.getExecutable();
    }

    public static enum ContainerRuntime {
        DOCKER("docker"),
        PODMAN("podman");

        private final String executable;

        private ContainerRuntime(String executable) {
            this.executable = executable;
        }

        public String getExecutable() {
            return this.executable;
        }
    }
}

