/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds.freemarker;

import hudson.model.Run;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Reports {
    private static volatile Reports instance = null;
    private HashMap<String, Report> reportsList = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Reports getInstance() {
        if (instance != null) return instance;
        Class<Reports> clazz = Reports.class;
        synchronized (Reports.class) {
            if (instance != null) return instance;
            instance = new Reports();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToUniqueReportsList(Run<?, ?> run, ReportData reportData) {
        Report report = this.reportsList.get(run.getRootDir().toString());
        if (report == null) {
            report = new Report(run);
            this.reportsList.put(run.getRootDir().toString(), report);
        }
        report.uniqueReports.add(reportData);
    }

    public Report getReport(Run<?, ?> run) {
        return this.reportsList.get(run.getRootDir().toString());
    }

    public void checkAndResetForNewRunIfNecessary(Run<?, ?> run) {
        this.clearOutOldReports();
        this.reportsList.putIfAbsent(run.getRootDir().toString(), new Report(run));
    }

    private void clearOutOldReports() {
        Iterator<Map.Entry<String, Report>> it = this.reportsList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Report> entry = it.next();
            if (entry.getValue().run.isBuilding() || entry.getValue().run.getResult() == null) continue;
            it.remove();
        }
    }

    public static class Report {
        Run<?, ?> run;
        ArrayList<ReportData> uniqueReports;

        public Report(Run<?, ?> run) {
            this.run = run;
            this.uniqueReports = new ArrayList();
        }

        public ArrayList<ReportData> getUniqueReports() {
            return this.uniqueReports;
        }
    }

    public static class ReportData {
        private String html;
        private String uniqueId;
        private boolean neverFail;

        public ReportData(String html, String uniqueId, boolean neverFail) {
            this.html = html;
            this.uniqueId = uniqueId;
            this.neverFail = neverFail;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public boolean isNeverFail() {
            return this.neverFail;
        }

        public void setNeverFail(boolean neverFail) {
            this.neverFail = neverFail;
        }
    }
}

