/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds.freemarker;

import com.crowdstrike.plugins.crwds.freemarker.AssessmentData;
import com.crowdstrike.plugins.crwds.freemarker.PolicyData;
import com.crowdstrike.plugins.crwds.freemarker.Reports;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashMap;

public class CSFreeMarker {
    private static volatile CSFreeMarker instance = null;
    private Configuration cfg = new Configuration(Configuration.VERSION_2_3_29);

    private CSFreeMarker() throws IOException, URISyntaxException {
        this.cfg.setClassForTemplateLoading(this.getClass(), "/templates/");
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
        this.cfg.setWrapUncheckedExceptions(true);
        this.cfg.setFallbackOnNullLoopVariable(false);
        DefaultObjectWrapper owraop = new DefaultObjectWrapper(Configuration.VERSION_2_3_28);
        owraop.setIterableSupport(true);
        owraop.setExposeFields(true);
        owraop.setExposureLevel(0);
        owraop.setMethodsShadowItems(true);
        owraop.setForceLegacyNonListCollections(true);
        owraop.setUseAdaptersForContainers(true);
        this.cfg.setObjectWrapper((ObjectWrapper)owraop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSFreeMarker getInstance() throws IOException, URISyntaxException {
        if (instance != null) return instance;
        Class<CSFreeMarker> clazz = CSFreeMarker.class;
        synchronized (CSFreeMarker.class) {
            if (instance != null) return instance;
            instance = new CSFreeMarker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String processAssessmentTemplate(AssessmentData assessmentData, PolicyData policyData, boolean neverFail, String uniqueId) throws IOException, TemplateException {
        Template template = this.cfg.getTemplate("index.ftl");
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("assessmentData", assessmentData);
        root.put("policyData", policyData);
        root.put("neverFail", neverFail);
        root.put("uniqueId", uniqueId);
        StringWriter stringWriter = new StringWriter();
        template.process(root, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public String processPaginatedTemplate(Reports.Report report) throws IOException, TemplateException {
        Template template = this.cfg.getTemplate("paginated.ftl");
        HashMap<String, Reports.Report> root = new HashMap<String, Reports.Report>();
        root.put("reports", report);
        StringWriter stringWriter = new StringWriter();
        template.process(root, (Writer)stringWriter);
        return stringWriter.toString();
    }
}

