/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds.freemarker;

import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AssessmentData {
    private final String[] severitiesList = new String[]{"critical", "high", "medium", "low", "negligible"};
    @SerializedName(value="ScanInfo")
    private ScanInfo scanInfo;
    @SerializedName(value="ImageInfo")
    private ImageInfo imageInfo;
    @SerializedName(value="Config")
    private Config config;
    @SerializedName(value="OSInfo")
    private OSInfo osInfo;
    @SerializedName(value="Vulnerabilities")
    private ArrayList<Vulnerabilities> vulnerabilities;
    @SerializedName(value="Detections")
    private ArrayList<Detections> detections;
    @SerializedName(value="Layers")
    private ArrayList<Layers> layers;
    @SerializedName(value="Packages")
    private ArrayList<Packages> packages;
    @SerializedName(value="ELFBinaries")
    private ArrayList<ELFBinaries> elfBinaries;
    @SerializedName(value="InventoryEngineInfo")
    private InventoryEngineInfo inventoryEngineInfo;
    @SerializedName(value="DetectionEngineInfo")
    private DetectionEngineInfo detectionEngineInfo;
    @SerializedName(value="Manifest")
    private Manifest manifest;

    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    public void setScanInfo(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public OSInfo getOsInfo() {
        return this.osInfo;
    }

    public void setOSInfo(OSInfo osInfo) {
        this.osInfo = osInfo;
    }

    public ArrayList<Vulnerabilities> getVulnerabilities() {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList();
        }
        return this.vulnerabilities;
    }

    public void setVulnerabilities(ArrayList<Vulnerabilities> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    public ArrayList<Detections> getDetections() {
        return this.detections;
    }

    public void setDetections(ArrayList<Detections> detections) {
        this.detections = detections;
    }

    public ArrayList<Layers> getLayers() {
        return this.layers;
    }

    public void setLayers(ArrayList<Layers> layers) {
        this.layers = layers;
    }

    public ArrayList<Packages> getPackages() {
        return this.packages;
    }

    public void setPackages(ArrayList<Packages> packages) {
        this.packages = packages;
    }

    public ArrayList<ELFBinaries> getElfBinaries() {
        return this.elfBinaries;
    }

    public void setELFBinaries(ArrayList<ELFBinaries> elfBinaries) {
        this.elfBinaries = elfBinaries;
    }

    public InventoryEngineInfo getInventoryEngineInfo() {
        return this.inventoryEngineInfo;
    }

    public void setInventoryEngineInfo(InventoryEngineInfo inventoryEngineInfo) {
        this.inventoryEngineInfo = inventoryEngineInfo;
    }

    public DetectionEngineInfo getDetectionEngineInfo() {
        return this.detectionEngineInfo;
    }

    public void setDetectionEngineInfo(DetectionEngineInfo detectionEngineInfo) {
        this.detectionEngineInfo = detectionEngineInfo;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public int vulnerabilitiesCriticalCount() {
        int count = 0;
        if (this.vulnerabilities != null) {
            for (Vulnerabilities vuls : this.vulnerabilities) {
                Vulnerabilities.Vulnerability vul = vuls.vulnerability;
                if (vul == null || vul.details == null || !vul.details.severity.equalsIgnoreCase("CRITICAL")) continue;
                ++count;
            }
        }
        return count;
    }

    public int vulnerabilitiesRemediationsCount() {
        int count = 0;
        if (this.vulnerabilities != null) {
            for (Vulnerabilities vuls : this.vulnerabilities) {
                Vulnerabilities.Vulnerability vul = vuls.vulnerability;
                if (vul == null) continue;
                count += vul.remediationsCount();
            }
        }
        return count;
    }

    public HashMap<String, Integer> severitiesAndCount() {
        LinkedHashMap<String, Integer> severities = new LinkedHashMap<String, Integer>();
        for (String s : this.severitiesList) {
            severities.put(s.toUpperCase(Locale.getDefault()), 0);
        }
        if (this.vulnerabilities != null) {
            for (Vulnerabilities vuls : this.vulnerabilities) {
                Vulnerabilities.Vulnerability vul;
                if (vuls.vulnerability == null || (vul = vuls.vulnerability).details == null) continue;
                Integer currCount = severities.getOrDefault(vul.details.severity.toUpperCase(Locale.getDefault()), 0);
                severities.put(vul.details.severity.toUpperCase(Locale.getDefault()), currCount + 1);
            }
        }
        return severities;
    }

    public ArrayList<Vulnerabilities.Vulnerability> vulnerabilityBySeverity(String severity) {
        ArrayList<Vulnerabilities.Vulnerability> vulns = new ArrayList<Vulnerabilities.Vulnerability>();
        if (this.vulnerabilities != null) {
            for (Vulnerabilities vuls : this.vulnerabilities) {
                Vulnerabilities.Vulnerability vul = vuls.vulnerability;
                if (vul == null || vul.details == null || !vul.details.severity.equalsIgnoreCase(severity)) continue;
                vulns.add(vul);
            }
        }
        return vulns;
    }

    public String vulnerabilityCVEIDByLayer(Layers layer) {
        if (this.vulnerabilities != null) {
            for (Vulnerabilities vul : this.vulnerabilities) {
                if (vul.vulnerability == null || !vul.vulnerability.layerHash.equalsIgnoreCase(layer.digest)) continue;
                return vul.vulnerability.cveId;
            }
        }
        return "";
    }

    public String severityColor(String severity) {
        switch (severity.toLowerCase(Locale.getDefault())) {
            case "critical": {
                return "critical";
            }
            case "high": {
                return "high";
            }
            case "medium": {
                return "medium";
            }
            case "low": {
                return "low";
            }
            case "negligible": {
                return "negligible";
            }
        }
        return "nh";
    }

    public String severityLabel(String severity) {
        switch (severity.toLowerCase(Locale.getDefault())) {
            case "critical": {
                return "Critical";
            }
            case "high": {
                return "High";
            }
            case "medium": {
                return "Medium";
            }
            case "low": {
                return "Low";
            }
            case "negligible": {
                return "Negligible";
            }
        }
        return "Unknown";
    }

    public String getIconByType(String type) {
        switch (type.toLowerCase(Locale.getDefault())) {
            case "success": {
                return "<svg class=\"mr-1\" width=\"25\" height=\"25\" viewBox=\"0 0 25 25\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M12.5 1.042C6.172 1.042 1.04 6.172 1.04 12.5S6.171 23.958 12.5 23.958c6.328 0 11.458-5.13 11.458-11.458S18.828 1.042 12.5 1.042zM9.627 18.016 5.68 14.069l1.473-1.473 2.474 2.474 7.557-7.557 1.473 1.472-9.03 9.03z\" fill=\"#06E5B7\"/>\n</svg>";
            }
            case "positive": {
                return "<svg class=\"mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M2 6.804c0-.317.225-.708.5-.866l9-5.196c.275-.16.725-.16 1 0l9 5.196c.275.159.5.548.5.865v10.393c0 .317-.225.707-.5.866l-9 5.197c-.275.159-.725.159-1 0l-9-5.197c-.275-.159-.5-.549-.5-.866V6.804z\" fill=\"#11e5b6\"/>\n</svg>";
            }
            case "failure": {
                return "<svg class=\"mr-1\" width=\"25\" height=\"25\" viewBox=\"0 0 25 25\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M12.5 1.042c-6.328 0-11.458 5.13-11.458 11.458S6.172 23.958 12.5 23.958s11.458-5.13 11.458-11.458S18.828 1.042 12.5 1.042zm5.424 15.41-1.473 1.472-3.95-3.951-3.952 3.951-1.473-1.473 3.951-3.951-3.95-3.951 1.472-1.473 3.951 3.951 3.951-3.95 1.473 1.472-3.951 3.951 3.951 3.951z\" fill=\"#fa4147\"/>\n</svg>";
            }
            case "critical": {
                return "<svg class=\"mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M2 6.804c0-.317.225-.708.5-.866l9-5.196c.275-.16.725-.16 1 0l9 5.196c.275.159.5.548.5.865v10.393c0 .317-.225.707-.5.866l-9 5.197c-.275.159-.725.159-1 0l-9-5.197c-.275-.159-.5-.549-.5-.866V6.804z\" fill=\"#fa4147\"/>\n</svg>";
            }
            case "high": {
                return "<svg class=\"mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M2 6.804c0-.317.225-.708.5-.866l9-5.196c.275-.16.725-.16 1 0l9 5.196c.275.159.5.548.5.865v10.393c0 .317-.225.707-.5.866l-9 5.197c-.275.159-.725.159-1 0l-9-5.197c-.275-.159-.5-.549-.5-.866V6.804z\" fill=\"#f77d40\"/>\n</svg>";
            }
            case "medium": {
                return "<svg class=\"mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M2 6.804c0-.317.225-.708.5-.866l9-5.196c.275-.16.725-.16 1 0l9 5.196c.275.159.5.548.5.865v10.393c0 .317-.225.707-.5.866l-9 5.197c-.275.159-.725.159-1 0l-9-5.197c-.275-.159-.5-.549-.5-.866V6.804z\" fill=\"#ffcc00\"/>\n</svg>";
            }
            case "info": 
            case "low": {
                return "<svg class=\"mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M2 6.804c0-.317.225-.708.5-.866l9-5.196c.275-.16.725-.16 1 0l9 5.196c.275.159.5.548.5.865v10.393c0 .317-.225.707-.5.866l-9 5.197c-.275.159-.725.159-1 0l-9-5.197c-.275-.159-.5-.549-.5-.866V6.804z\" fill=\"#9dc1fd\"/>\n</svg>";
            }
            case "arrow": {
                return "<svg class=\"i-arrow mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M12 13.586 8.352 9.94a.5.5 0 0 0-.707.707L12 15l4.354-4.354a.498.498 0 0 0 0-.708.5.5 0 0 0-.707 0L12 13.586z\" fill=\"#fafafa\"/>\n</svg>";
            }
        }
        return "<svg class=\"mr-1\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n    <path d=\"M2 6.804c0-.317.225-.708.5-.866l9-5.196c.275-.16.725-.16 1 0l9 5.196c.275.159.5.548.5.865v10.393c0 .317-.225.707-.5.866l-9 5.197c-.275.159-.725.159-1 0l-9-5.197c-.275-.159-.5-.549-.5-.866V6.804z\" fill=\"#63646e\"/>\n</svg>";
    }

    public static String timeFormat(String field) {
        try {
            Instant instant = Instant.parse(field);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM d yyyy',' 'at' hh:mm:ss a O");
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, TimeZone.getDefault().toZoneId());
            return zdt.format(formatter);
        }
        catch (Exception e) {
            return field == null ? "" : field;
        }
    }

    public String toString() {
        return "Scan Info: " + this.scanInfo.toString() + "\nImage Info: " + this.imageInfo.toString() + "\nConfig: " + this.config.toString() + "\nOS Info: " + this.osInfo.toString() + "\nVulnerabilities: " + this.vulnerabilities.toString() + "\nDetections: " + this.detections.toString() + "\nLayers: " + this.layers.toString() + "\nPackages: " + this.packages.toString() + "\nELF Binaries: " + this.elfBinaries.toString() + "\nInventory Engine Info: " + this.inventoryEngineInfo.toString() + "\nDetection Engine Info: " + this.detectionEngineInfo.toString();
    }

    public static class ScanInfo {
        @SerializedName(value="CID")
        private String cid;
        @SerializedName(value="Username")
        private String username;
        @SerializedName(value="UserUUID")
        private String userUUID;
        @SerializedName(value="ScanUUID")
        private String scanUUID;
        @SerializedName(value="CorrelationUUID")
        private String correlationUUID;
        @SerializedName(value="RequestedAt")
        private String requestedAt;

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getUserUUID() {
            return this.userUUID;
        }

        public void setUserUUID(String userUUID) {
            this.userUUID = userUUID;
        }

        public String getScanUUID() {
            return this.scanUUID;
        }

        public void setScanUUID(String scanUUID) {
            this.scanUUID = scanUUID;
        }

        public String getCorrelationUUID() {
            return this.correlationUUID;
        }

        public void setCorrelationUUID(String correlationUUID) {
            this.correlationUUID = correlationUUID;
        }

        public String getRequestedAt() {
            return this.requestedAt;
        }

        public void setRequestedAt(String requestedAt) {
            this.requestedAt = requestedAt;
        }

        public String getRequestedAtFormatted() {
            return AssessmentData.timeFormat(this.requestedAt);
        }

        public String toString() {
            return "cid : " + this.cid + "\nusername : " + this.username + "\nuserUUID : " + this.userUUID + "\nscanUUID : " + this.scanUUID + "\ncorrelationUUID : " + this.correlationUUID + "\nrequestedAt : " + this.requestedAt;
        }
    }

    public static class ImageInfo {
        @SerializedName(value="Registry")
        private String registry;
        @SerializedName(value="Repository")
        private String repository;
        @SerializedName(value="Tag")
        private String tag;
        @SerializedName(value="ID")
        private String id;
        @SerializedName(value="Digest")
        private String digest;
        @SerializedName(value="Size")
        private String size;
        @SerializedName(value="CreatedAt")
        private String createdAt;
        @SerializedName(value="Architecture")
        private String architecture;
        @SerializedName(value="scan_request_s3_key")
        private String scan_request_s3_key;

        public String getRegistry() {
            return this.registry;
        }

        public void setRegistry(String registry) {
            this.registry = registry;
        }

        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String ID) {
            this.id = ID;
        }

        public String getDigest() {
            return this.digest;
        }

        public void setDigest(String digest) {
            this.digest = digest;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getCreatedAt() {
            return AssessmentData.timeFormat(this.createdAt);
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public String getScan_request_s3_key() {
            return this.scan_request_s3_key;
        }

        public void setScan_request_s3_key(String scan_request_s3_key) {
            this.scan_request_s3_key = scan_request_s3_key;
        }

        public String toString() {
            return "registry: " + this.registry + "\nrepository: " + this.repository + "\ntag: " + this.tag + "\nid: " + this.id + "\ndigest: " + this.digest + "\nsize: " + this.size + "\ncreatedAt: " + this.createdAt + "\narchitecture: " + this.architecture + "\nscanRequestS3Key: " + this.scan_request_s3_key;
        }
    }

    public static class Config {
        private String created;
        private String architecture;
        private String os;

        public String getCreated() {
            return AssessmentData.timeFormat(this.created);
        }

        public void setCreated(String created) {
            this.created = created;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String toString() {
            return "created: " + this.created + "\narchitecture: " + this.architecture + "\nos: " + this.os;
        }
    }

    public static class OSInfo {
        @SerializedName(value="Name")
        private String name;
        @SerializedName(value="Version")
        private String version;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "name: " + this.name + "\nversion: " + this.version;
        }
    }

    public static class InventoryEngineInfo {
        @SerializedName(value="CollectedAt")
        private String collectedAt;
        @SerializedName(value="EngineVersion")
        private String engineVersion;
        @SerializedName(value="CWPPScannerVersion")
        private String cwppScannerVersion;
        @SerializedName(value="ELFModelVersion")
        private String elfModelVersion;

        public String getCollectedAt() {
            return AssessmentData.timeFormat(this.collectedAt);
        }

        public void setCollectedAt(String collectedAt) {
            this.collectedAt = collectedAt;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public String getCwppScannerVersion() {
            return this.cwppScannerVersion;
        }

        public void setCwppScannerVersion(String CWPPScannerVersion) {
            this.cwppScannerVersion = CWPPScannerVersion;
        }

        public String getElfModelVersion() {
            return this.elfModelVersion;
        }

        public void setElfModelVersion(String ELFModelVersion) {
            this.elfModelVersion = ELFModelVersion;
        }
    }

    public static class DetectionEngineInfo {
        @SerializedName(value="PerformedAt")
        private String performedAt;
        @SerializedName(value="EngineVersion")
        private String engineVersion;

        public String getPerformedAt() {
            return AssessmentData.timeFormat(this.performedAt);
        }

        public void setPerformedAt(String performedAt) {
            this.performedAt = performedAt;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }
    }

    public static class Manifest {
        private int schemaVersion;
        private String mediaType;
        private Config config;

        public int getSchemaVersion() {
            return this.schemaVersion;
        }

        public void setSchemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public Config getConfig() {
            return this.config;
        }

        public void setConfig(Config config) {
            this.config = config;
        }

        public static class Config {
            private String mediaType;
            private int size;
            private String digest;

            public String getMediaType() {
                return this.mediaType;
            }

            public void setMediaType(String mediaType) {
                this.mediaType = mediaType;
            }

            public int getSize() {
                return this.size;
            }

            public void setSize(int size) {
                this.size = size;
            }

            public String getDigest() {
                return this.digest;
            }

            public void setDigest(String digest) {
                this.digest = digest;
            }
        }
    }

    public static class Vulnerabilities {
        @SerializedName(value="Vulnerability")
        private Vulnerability vulnerability;

        public Vulnerability getVulnerability() {
            return this.vulnerability;
        }

        public void setVulnerability(Vulnerability vulnerability) {
            this.vulnerability = vulnerability;
        }

        public static class Vulnerability {
            @SerializedName(value="CVEID")
            private String cveId;
            @SerializedName(value="LayerHash")
            private String layerHash;
            @SerializedName(value="FirstSeen")
            private String firstSeen;
            @SerializedName(value="Product")
            private Product product;
            @SerializedName(value="ContentDataHash")
            private String contentDataHash;
            @SerializedName(value="Remediation")
            private ArrayList<String> remediation;
            @SerializedName(value="Details")
            private Details details;
            @SerializedName(value="ExploitedDetails")
            private ExploitedDetails exploitedDetails;

            public String getCveId() {
                return this.cveId;
            }

            public void setCveId(String CVEID) {
                this.cveId = CVEID;
            }

            public String getLayerHash() {
                return this.layerHash;
            }

            public void setLayerHash(String layerHash) {
                this.layerHash = layerHash;
            }

            public String getFirstSeen() {
                return AssessmentData.timeFormat(this.firstSeen);
            }

            public void setFirstSeen(String firstSeen) {
                this.firstSeen = firstSeen;
            }

            public Product getProduct() {
                return this.product;
            }

            public void setProduct(Product product) {
                this.product = product;
            }

            public String getContentDataHash() {
                return this.contentDataHash;
            }

            public void setContentDataHash(String contentDataHash) {
                this.contentDataHash = contentDataHash;
            }

            public ArrayList<String> getRemediation() {
                return this.remediation;
            }

            public void setRemediation(ArrayList<String> remediation) {
                this.remediation = remediation;
            }

            public Details getDetails() {
                return this.details;
            }

            public void setDetails(Details details) {
                this.details = details;
            }

            public ExploitedDetails getExploitedDetails() {
                return this.exploitedDetails;
            }

            public void setExploitedDetails(ExploitedDetails exploitedDetails) {
                this.exploitedDetails = exploitedDetails;
            }

            public int remediationsCount() {
                int count = 0;
                if (this.remediation != null) {
                    for (String s : this.remediation) {
                        if (this.isHash(s)) continue;
                        ++count;
                    }
                }
                return count;
            }

            public boolean isHash(String hash) {
                Pattern pattern = Pattern.compile("[a-f0-9]{32}", 2);
                Matcher matcher = pattern.matcher(hash);
                return matcher.find();
            }

            public ArrayList<String> getRemediationsIfNotHash() {
                ArrayList<String> remediations = new ArrayList<String>();
                if (this.remediation != null) {
                    for (String s : this.remediation) {
                        if (this.isHash(s)) continue;
                        remediations.add(s);
                    }
                }
                return remediations;
            }

            public static class Details {
                private String id;
                private String cvss_version;
                private String source_type;
                private String source;
                private String description;
                private String vector;
                private double base_score;
                private String severity;
                private double exploitability_score;
                private double impact_score;
                private ArrayList<References> references;

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public String getCvss_version() {
                    return this.cvss_version;
                }

                public void setCvss_version(String cvss_version) {
                    this.cvss_version = cvss_version;
                }

                public String getSource_type() {
                    return this.source_type;
                }

                public void setSource_type(String source_type) {
                    this.source_type = source_type;
                }

                public String getSource() {
                    return this.source;
                }

                public void setSource(String source) {
                    this.source = source;
                }

                public String getDescription() {
                    return this.description;
                }

                public void setDescription(String description) {
                    this.description = description;
                }

                public String getVector() {
                    return this.vector;
                }

                public void setVector(String vector) {
                    this.vector = vector;
                }

                public double getBase_score() {
                    return this.base_score;
                }

                public void setBase_score(double base_score) {
                    this.base_score = base_score;
                }

                public String getSeverity() {
                    return this.severity;
                }

                public void setSeverity(String severity) {
                    this.severity = severity;
                }

                public double getExploitability_score() {
                    return this.exploitability_score;
                }

                public void setExploitability_score(double exploitability_score) {
                    this.exploitability_score = exploitability_score;
                }

                public double getImpact_score() {
                    return this.impact_score;
                }

                public void setImpact_score(double impact_score) {
                    this.impact_score = impact_score;
                }

                public ArrayList<References> getReferences() {
                    return this.references;
                }

                public void setReferences(ArrayList<References> references) {
                    this.references = references;
                }
            }

            public static class Product {
                private String packageSource;

                public String getPackageSource() {
                    return this.packageSource;
                }

                public void setPackageSource(String PackageSource) {
                    this.packageSource = PackageSource;
                }
            }

            public static class ExploitedDetails {
            }

            public static class References {
                @SerializedName(value="URL")
                private String url;
                @SerializedName(value="Tags")
                private ArrayList<String> tags;

                public String getUrl() {
                    return this.url;
                }

                public void setUrl(String URL2) {
                    this.url = URL2;
                }

                public ArrayList<String> getTags() {
                    return this.tags;
                }

                public void setTags(ArrayList<String> Tags) {
                    this.tags = Tags;
                }
            }
        }
    }

    public static class Layers {
        @SerializedName(value="Digest")
        private String digest;
        @SerializedName(value="Size")
        private String size;
        @SerializedName(value="CreatedAt")
        private String createdAt;
        @SerializedName(value="CreatedBy")
        private String createdBy;
        private String type;
        private String layer_inventory_s3_key;

        public String getDigest() {
            return this.digest;
        }

        public void setDigest(String digest) {
            this.digest = digest;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getCreatedAt() {
            return AssessmentData.timeFormat(this.createdAt);
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLayer_inventory_s3_key() {
            return this.layer_inventory_s3_key;
        }

        public void setLayer_inventory_s3_key(String layer_inventory_s3_key) {
            this.layer_inventory_s3_key = layer_inventory_s3_key;
        }
    }

    public static class ELFBinaries {
        @SerializedName(value="Path")
        private String path;
        @SerializedName(value="Hash")
        private String hash;
        @SerializedName(value="Size")
        private int size;
        @SerializedName(value="Permissions")
        private String permissions;
        @SerializedName(value="Details")
        private String details;
        @SerializedName(value="Malicious")
        private boolean malicious;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }

        public boolean isMalicious() {
            return this.malicious;
        }

        public void setMalicious(boolean malicious) {
            this.malicious = malicious;
        }
    }

    public static class Packages {
        @SerializedName(value="Vendor")
        private String vendor;
        @SerializedName(value="Product")
        private String product;
        @SerializedName(value="MajorVersion")
        private String majorVersion;
        @SerializedName(value="SoftwareArchitecture")
        private String softwareArchitecture;
        @SerializedName(value="PackageProvider")
        private String packageProvider;
        @SerializedName(value="PackageSource")
        private String packageSource;
        @SerializedName(value="LayerHash")
        private String layerHash;
        @SerializedName(value="LayerIndex")
        private int layerIndex;

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String product) {
            this.product = product;
        }

        public String getMajorVersion() {
            return this.majorVersion;
        }

        public void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        public String getSoftwareArchitecture() {
            return this.softwareArchitecture;
        }

        public void setSoftwareArchitecture(String softwareArchitecture) {
            this.softwareArchitecture = softwareArchitecture;
        }

        public String getPackageProvider() {
            return this.packageProvider;
        }

        public void setPackageProvider(String packageProvider) {
            this.packageProvider = packageProvider;
        }

        public String getPackageSource() {
            return this.packageSource;
        }

        public void setPackageSource(String packageSource) {
            this.packageSource = packageSource;
        }

        public String getLayerHash() {
            return this.layerHash;
        }

        public void setLayerHash(String layerHash) {
            this.layerHash = layerHash;
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public void setLayerIndex(int layerIndex) {
            this.layerIndex = layerIndex;
        }
    }

    public static class Detections {
        @SerializedName(value="Detection")
        private Detection detection;

        public Detections(Detection detection) {
            this.detection = detection;
        }

        public Detection getDetection() {
            return this.detection;
        }

        public void setDetection(Detection detection) {
            this.detection = detection;
        }

        public String toString() {
            return this.detection.toString();
        }

        public static class Detection {
            @SerializedName(value="ID")
            private String id;
            @SerializedName(value="Type")
            private String type;
            @SerializedName(value="Name")
            private String name;
            @SerializedName(value="Title")
            private String title;
            @SerializedName(value="Description")
            private String description;
            @SerializedName(value="Remediation")
            private String remediation;
            @SerializedName(value="Severity")
            private String severity;

            public String getId() {
                return this.id;
            }

            public void setId(String ID) {
                this.id = ID;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getTitle() {
                return this.title;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public String getRemediation() {
                return this.remediation;
            }

            public void setRemediation(String remediation) {
                this.remediation = remediation;
            }

            public String getSeverity() {
                return this.severity;
            }

            public void setSeverity(String severity) {
                this.severity = severity;
            }

            public String toString() {
                return "ID: " + this.id + "\ntype: " + this.type + "\nname: " + this.name + "\ntitle: " + this.title + "\ndescription: " + this.description + "\nremediation: " + this.remediation + "\nseverity: " + this.severity;
            }
        }
    }
}

