/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds.credentials;

import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.crowdstrike.plugins.crwds.FalconContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Optional;

public interface FalconClientIdAndToken
extends StandardUsernamePasswordCredentials {
    @NonNull
    public Secret getSecret() throws IOException, InterruptedException;

    @NonNull
    public String getClientID();

    public static String getSecret(FalconContext context, String FalconCredentialId) throws IOException, InterruptedException {
        return FalconClientIdAndToken.getCredentialsById(context, FalconCredentialId).getSecret().getPlainText();
    }

    public static String getClientID(FalconContext context, String FalconCredentialId) throws IOException {
        return FalconClientIdAndToken.getCredentialsById(context, FalconCredentialId).getClientID();
    }

    public static FalconClientIdAndToken getCredentialsById(FalconContext context, String FalconCredentialId) throws IOException {
        return Optional.ofNullable((FalconClientIdAndToken)CredentialsProvider.findCredentialById((String)FalconCredentialId, FalconClientIdAndToken.class, context.getRun(), (DomainRequirement[])new DomainRequirement[0])).orElseThrow(() -> new IOException("Falcon client Id and credential Id '" + FalconCredentialId + "' was not found. Please configure the build properly and retry."));
    }

    public static class NameProvider
    extends CredentialsNameProvider<FalconClientIdAndToken> {
        @NonNull
        public String getName(FalconClientIdAndToken credentials) {
            String description = Util.fixEmptyAndTrim((String)credentials.getDescription());
            return description != null ? description : credentials.getId();
        }
    }
}

