/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.crowdstrike.plugins.crwds.credentials.FalconClientIdAndToken;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;

public class CredentialsDefault
extends BaseStandardCredentials
implements FalconClientIdAndToken {
    private static final long serialVersionUID = 1L;
    private final String clientID;
    private final Secret secret;

    @DataBoundConstructor
    public CredentialsDefault(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String clientID, @NonNull String secret) {
        super(scope, id, description);
        this.clientID = clientID;
        this.secret = Secret.fromString((String)secret);
    }

    @Override
    @NonNull
    public String getClientID() {
        return this.clientID;
    }

    @Override
    @NonNull
    public Secret getSecret() {
        return this.secret;
    }

    @NonNull
    public String getUsername() {
        return "cs-user";
    }

    public boolean isUsernameSecret() {
        return FalconClientIdAndToken.super.isUsernameSecret();
    }

    @NonNull
    public Secret getPassword() {
        return this.secret;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "CrowdStrike Falcon API";
        }
    }
}

