/*
 * Decompiled with CFR 0.152.
 */
package com.crowdstrike.plugins.crwds;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.crowdstrike.plugins.crwds.FalconContext;
import com.crowdstrike.plugins.crwds.FalconStepFlow;
import com.crowdstrike.plugins.crwds.configuration.DescriptorConfiguration;
import com.crowdstrike.plugins.crwds.configuration.FalconConfiguration;
import com.crowdstrike.plugins.crwds.credentials.FalconClientIdAndToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CrowdStrikeSecurityBuilder
extends Builder
implements SimpleBuildStep,
FalconConfiguration {
    private boolean enforce;
    private boolean skipImageUpload;
    private String imageName;
    private String imageTag;
    private Integer timeout;

    @DataBoundConstructor
    public CrowdStrikeSecurityBuilder(String imageName, String imageTag, boolean enforce, boolean skipImageUpload, Integer timeout) {
        this.imageName = imageName;
        this.imageTag = imageTag;
        this.enforce = enforce;
        this.skipImageUpload = skipImageUpload;
        this.timeout = timeout;
    }

    @Override
    public boolean getEnforce() {
        return this.enforce;
    }

    @Override
    public boolean getSkipImageUpload() {
        return this.skipImageUpload;
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public String getImageTag() {
        return this.imageTag;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    @DataBoundSetter
    public void setImageTag(String imageTag) {
        this.imageTag = imageTag;
    }

    @DataBoundSetter
    public void setEnforce(boolean enforce) {
        this.enforce = enforce;
    }

    @DataBoundSetter
    public void setSkipImageUpload(boolean skipImageUpload) {
        this.skipImageUpload = skipImageUpload;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public FalconStepBuilderDescriptor getDescriptor() {
        return (FalconStepBuilderDescriptor)super.getDescriptor();
    }

    @Override
    public String getFalconCloud() {
        return this.getDescriptor().getFalconCloud();
    }

    @Override
    public String getFalconCredentialId() {
        return this.getDescriptor().getFalconCredentialId();
    }

    public boolean getValueOfNonCompliance(boolean currentState) {
        return this.enforce == currentState;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        FalconStepFlow.perform(this, () -> FalconContext.forJenkinsProject(run, workspace, launcher, listener));
    }

    @Symbol(value={"crowdStrikeSecurity"})
    @Extension
    public static final class FalconStepBuilderDescriptor
    extends BuildStepDescriptor<Builder>
    implements DescriptorConfiguration {
        private String falconCloud;
        private String falconCredentialId;
        private String containerRuntime = "docker";

        public FalconStepBuilderDescriptor() {
            this.load();
        }

        public FormValidation doCheckImageName(@QueryParameter String value) {
            if (value.matches("^\\$?[a-zA-Z\\d]+(?:[._-]{1,2}[a-zA-Z\\d]+)*") && value.length() < 4096) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Image Name is required. Please check Helper Texts(?) for details.");
        }

        public FormValidation doCheckImageTag(@QueryParameter String value) {
            if (value.matches("^\\$?[a-zA-Z\\d_.-]{1,127}")) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)"Image Tag is required. Please check Helper Texts(?) for details.");
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                int number = Integer.parseInt(value);
                if (number < 1 || number > 1799) {
                    return FormValidation.warning((String)"Timeout is required. Please check Helper Texts(?) for details.");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.warning((String)"Timeout is required. Please check Helper Texts(?) for details.");
            }
        }

        public FormValidation doCheckContainerRuntime(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Container runtime must be specified");
            }
            if (!value.equalsIgnoreCase("docker") && !value.equalsIgnoreCase("podman")) {
                return FormValidation.error((String)"Container runtime must be either docker or podman");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
            request.bindJSON((Object)this, formData);
            this.save();
            return super.configure(request, formData);
        }

        public ListBoxModel doFillFalconCloudItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("us-1.crowdstrike.com", "us-1.crowdstrike.com");
            items.add("eu-1.crowdstrike.com", "eu-1.crowdstrike.com");
            items.add("us-2.crowdstrike.com", "us-2.crowdstrike.com");
            items.add("laggar.gcw.crowdstrike.com", "laggar.gcw.crowdstrike.com");
            items.add("us-gov-2.crowdstrike.com", "us-gov-2.crowdstrike.com");
            return items;
        }

        public ListBoxModel doFillContainerRuntimeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Docker (Default)", "docker");
            items.add("Podman", "podman");
            return items;
        }

        @Override
        public String getFalconCloud() {
            return this.falconCloud;
        }

        @Override
        public String getFalconCredentialId() {
            return this.falconCredentialId;
        }

        public String getContainerRuntime() {
            return this.containerRuntime;
        }

        @DataBoundSetter
        public void setFalconCloud(String falconCloud) {
            this.falconCloud = falconCloud;
        }

        @DataBoundSetter
        public void setFalconCredentialId(String falconCredentialId) {
            this.falconCredentialId = falconCredentialId;
        }

        @DataBoundSetter
        public void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        public ListBoxModel doFillFalconCredentialIdItems(@AncestorInPath Item item, @QueryParameter String falconCredentialId) {
            Jenkins jenkins;
            StandardListBoxModel model = new StandardListBoxModel();
            if (item == null ? !(jenkins = Jenkins.get()).hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return model.includeCurrentValue(falconCredentialId);
            }
            return model.includeEmptyValue().includeAs(ACL.SYSTEM, item, FalconClientIdAndToken.class).includeCurrentValue(falconCredentialId);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "CrowdStrike Security Plugin";
        }
    }
}

