/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.restapi;

import io.jenkins.plugins.coverage.metrics.restapi.CoverageApi;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.NavigableMap;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class CoverageApiAssert
extends AbstractObjectAssert<CoverageApiAssert, CoverageApi> {
    public CoverageApiAssert(CoverageApi actual) {
        super((Object)actual, CoverageApiAssert.class);
    }

    @CheckReturnValue
    public static CoverageApiAssert assertThat(CoverageApi actual) {
        return new CoverageApiAssert(actual);
    }

    public CoverageApiAssert hasModifiedFilesDelta(NavigableMap modifiedFilesDelta) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting modifiedFilesDelta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NavigableMap actualModifiedFilesDelta = ((CoverageApi)this.actual).getModifiedFilesDelta();
        if (!Objects.deepEquals(actualModifiedFilesDelta, modifiedFilesDelta)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, modifiedFilesDelta, actualModifiedFilesDelta});
        }
        return this;
    }

    public CoverageApiAssert hasModifiedFilesStatistics(NavigableMap modifiedFilesStatistics) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting modifiedFilesStatistics of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NavigableMap actualModifiedFilesStatistics = ((CoverageApi)this.actual).getModifiedFilesStatistics();
        if (!Objects.deepEquals(actualModifiedFilesStatistics, modifiedFilesStatistics)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, modifiedFilesStatistics, actualModifiedFilesStatistics});
        }
        return this;
    }

    public CoverageApiAssert hasModifiedLinesDelta(NavigableMap modifiedLinesDelta) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting modifiedLinesDelta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NavigableMap actualModifiedLinesDelta = ((CoverageApi)this.actual).getModifiedLinesDelta();
        if (!Objects.deepEquals(actualModifiedLinesDelta, modifiedLinesDelta)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, modifiedLinesDelta, actualModifiedLinesDelta});
        }
        return this;
    }

    public CoverageApiAssert hasModifiedLinesStatistics(NavigableMap modifiedLinesStatistics) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting modifiedLinesStatistics of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NavigableMap actualModifiedLinesStatistics = ((CoverageApi)this.actual).getModifiedLinesStatistics();
        if (!Objects.deepEquals(actualModifiedLinesStatistics, modifiedLinesStatistics)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, modifiedLinesStatistics, actualModifiedLinesStatistics});
        }
        return this;
    }

    public CoverageApiAssert hasProjectDelta(NavigableMap projectDelta) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting projectDelta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NavigableMap actualProjectDelta = ((CoverageApi)this.actual).getProjectDelta();
        if (!Objects.deepEquals(actualProjectDelta, projectDelta)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, projectDelta, actualProjectDelta});
        }
        return this;
    }

    public CoverageApiAssert hasProjectStatistics(NavigableMap projectStatistics) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting projectStatistics of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        NavigableMap actualProjectStatistics = ((CoverageApi)this.actual).getProjectStatistics();
        if (!Objects.deepEquals(actualProjectStatistics, projectStatistics)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, projectStatistics, actualProjectStatistics});
        }
        return this;
    }

    public CoverageApiAssert hasQualityGates(QualityGateResult.QualityGateResultApi qualityGates) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting qualityGates of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        QualityGateResult.QualityGateResultApi actualQualityGates = ((CoverageApi)this.actual).getQualityGates();
        if (!Objects.deepEquals(actualQualityGates, qualityGates)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, qualityGates, actualQualityGates});
        }
        return this;
    }

    public CoverageApiAssert hasReferenceBuild(String referenceBuild) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting referenceBuild of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualReferenceBuild = ((CoverageApi)this.actual).getReferenceBuild();
        if (!Objects.deepEquals(actualReferenceBuild, referenceBuild)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, referenceBuild, actualReferenceBuild});
        }
        return this;
    }
}

