/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.service;

import hudson.scheduler.CronTab;
import io.jenkins.plugins.extended_timer_trigger.CronTabWrapper;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;

public abstract class CronWrapper<T> {
    public abstract Calendar ceil(long var1);

    public abstract Calendar floor(long var1);

    public abstract T getCronTab();

    public static class ExtendedCronTab
    extends CronWrapper<CronTabWrapper> {
        private final CronTabWrapper cronTab;

        public ExtendedCronTab(CronTabWrapper cronTab) {
            this.cronTab = cronTab;
        }

        @Override
        public Calendar ceil(long timeInMillis) {
            ZonedDateTime ceil = this.cronTab.ceil(timeInMillis);
            if (ceil != null) {
                return GregorianCalendar.from(ceil);
            }
            return null;
        }

        @Override
        public Calendar floor(long timeInMillis) {
            ZonedDateTime ceil = this.cronTab.floor(timeInMillis);
            if (ceil != null) {
                return GregorianCalendar.from(ceil);
            }
            return null;
        }

        @Override
        public CronTabWrapper getCronTab() {
            return this.cronTab;
        }
    }

    public static class ParameterizedCronWrapper
    extends CronWrapper<ParameterizedCronTab> {
        private final ParameterizedCronTab cronTab;

        public ParameterizedCronWrapper(ParameterizedCronTab cronTab) {
            this.cronTab = cronTab;
        }

        @Override
        public Calendar ceil(long timeInMillis) {
            return this.cronTab.ceil(timeInMillis);
        }

        @Override
        public Calendar floor(long timeInMillis) {
            return this.cronTab.floor(timeInMillis);
        }

        @Override
        public ParameterizedCronTab getCronTab() {
            return this.cronTab;
        }
    }

    public static class ClassicCronTab
    extends CronWrapper<CronTab> {
        private final CronTab cronTab;

        public ClassicCronTab(CronTab cronTab) {
            this.cronTab = cronTab;
        }

        @Override
        public Calendar ceil(long timeInMillis) {
            return this.cronTab.ceil(timeInMillis);
        }

        @Override
        public Calendar floor(long timeInMillis) {
            return this.cronTab.floor(timeInMillis);
        }

        @Override
        public CronTab getCronTab() {
            return this.cronTab;
        }
    }
}

