/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.service;

import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import io.jenkins.plugins.view.calendar.CalendarView;
import io.jenkins.plugins.view.calendar.time.Moment;
import io.jenkins.plugins.view.calendar.util.PluginUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CronJobService {
    private final transient Moment now;

    public CronJobService() {
        this(new Moment());
    }

    public CronJobService(Moment now) {
        this.now = now;
    }

    public List<CronTab> getCronTabs(Trigger trigger) {
        return this.getCronTabs(trigger, null);
    }

    public List<CronTab> getCronTabs(Trigger trigger, Hash hash) {
        ArrayList<CronTab> cronTabs = new ArrayList<CronTab>();
        boolean isParameterizedTrigger = PluginUtil.hasParameterizedSchedulerPluginInstalled() && trigger instanceof ParameterizedTimerTrigger;
        int lineNumber = 0;
        String timezone = null;
        String specification = isParameterizedTrigger ? ((ParameterizedTimerTrigger)trigger).getParameterizedSpecification() : trigger.getSpec();
        for (String line : specification.split("\\r?\\n")) {
            ++lineNumber;
            if (isParameterizedTrigger) {
                line = line.split("%")[0];
            }
            line = line.trim();
            if (lineNumber == 1 && line.startsWith("TZ=")) {
                timezone = CronTabList.getValidTimezone((String)line.replace("TZ=", ""));
                continue;
            }
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            try {
                CronTab cronTab = new CronTab(line, lineNumber, hash, timezone);
                cronTabs.add(cronTab);
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to parse cron trigger spec: '" + line + "'";
                Logger.getLogger(this.getClass()).error((Object)msg, (Throwable)e);
            }
        }
        return cronTabs;
    }

    public List<Trigger> getCronTriggers(Job job, CalendarView.CalendarViewEventsType eventsType) {
        Collection jobTriggers;
        if (job instanceof AbstractProject) {
            jobTriggers = ((AbstractProject)job).getTriggers().values();
        } else if (PluginUtil.hasWorkflowJobPluginInstalled() && job instanceof WorkflowJob) {
            jobTriggers = ((WorkflowJob)job).getTriggers().values();
        } else {
            return Collections.emptyList();
        }
        ArrayList<Trigger> cronTriggers = new ArrayList<Trigger>();
        for (Trigger jobTrigger : jobTriggers) {
            if (eventsType != CalendarView.CalendarViewEventsType.ALL && !(eventsType == CalendarView.CalendarViewEventsType.BUILDS ^ jobTrigger instanceof SCMTrigger)) continue;
            if (StringUtils.isNotBlank((String)jobTrigger.getSpec())) {
                cronTriggers.add(jobTrigger);
                continue;
            }
            if (!PluginUtil.hasParameterizedSchedulerPluginInstalled() || !(jobTrigger instanceof ParameterizedTimerTrigger) || !StringUtils.isNotBlank((String)((ParameterizedTimerTrigger)jobTrigger).getParameterizedSpecification())) continue;
            cronTriggers.add(jobTrigger);
        }
        return cronTriggers;
    }

    public List<CronTab> getCronTabs(Job job, CalendarView.CalendarViewEventsType eventsType) {
        ArrayList<CronTab> cronTabs = new ArrayList<CronTab>();
        for (Trigger trigger : this.getCronTriggers(job, eventsType)) {
            cronTabs.addAll(this.getCronTabs(trigger, Hash.from((String)job.getFullName())));
        }
        return cronTabs;
    }

    public Calendar getNextStart(Job job, CalendarView.CalendarViewEventsType eventsType) {
        Calendar next = null;
        List<CronTab> cronTabs = this.getCronTabs(job, eventsType);
        for (CronTab cronTab : cronTabs) {
            Calendar ceil = cronTab.ceil(this.now.nextMinute().getTimeInMillis());
            if (next != null && !ceil.before(next)) continue;
            next = ceil;
            next.set(13, 0);
            next.set(14, 0);
        }
        return next;
    }
}

