/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.event;

import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.view.calendar.CalendarView;
import io.jenkins.plugins.view.calendar.event.CalendarEvent;
import io.jenkins.plugins.view.calendar.event.CalendarEventState;
import io.jenkins.plugins.view.calendar.event.ScheduledCalendarEvent;
import io.jenkins.plugins.view.calendar.event.StartedCalendarEvent;
import io.jenkins.plugins.view.calendar.service.CalendarEventService;
import io.jenkins.plugins.view.calendar.time.Moment;
import io.jenkins.plugins.view.calendar.time.MomentRange;
import io.jenkins.plugins.view.calendar.util.DateUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CalendarEventFactory {
    private final transient Moment now;
    private final transient CalendarEventService calendarEventService;

    public CalendarEventFactory(Moment now, CalendarEventService calendarEventService) {
        this.now = now;
        this.calendarEventService = calendarEventService;
    }

    public ScheduledCalendarEvent createScheduledEvent(Job job, Calendar start, long duration) {
        return new ScheduledCalendarEventImpl(job, start, duration);
    }

    public StartedCalendarEvent createStartedEvent(Job job, Run build) {
        return new StartedCalendarEventImpl(job, build);
    }

    private class ScheduledCalendarEventImpl
    extends CalendarEventImpl
    implements ScheduledCalendarEvent {
        public ScheduledCalendarEventImpl(Job job, Calendar start, long durationInMillis) {
            this.job = job;
            this.id = this.initId(job.getUrl(), start.getTimeInMillis());
            this.title = job.getFullDisplayName();
            this.url = job.getUrl();
            this.duration = durationInMillis;
            this.start = new Moment(start);
            this.end = this.initEnd(start.getTimeInMillis(), durationInMillis);
        }

        @Override
        public CalendarEventState getState() {
            return CalendarEventState.SCHEDULED;
        }

        @Override
        public String getIconClassName() {
            return "symbol-weather-" + this.job.getBuildHealth().getIconClassName();
        }
    }

    private class StartedCalendarEventImpl
    extends CalendarEventImpl
    implements StartedCalendarEvent {
        private final Run build;
        private final CalendarEventState state;
        private transient StartedCalendarEvent previousEvent;
        private transient StartedCalendarEvent nextEvent;
        private transient ScheduledCalendarEvent nextScheduledEvent;

        public StartedCalendarEventImpl(Job job, Run build) {
            this.id = this.initId(job.getUrl(), build.getStartTimeInMillis());
            this.job = job;
            this.build = build;
            this.title = build.getFullDisplayName();
            this.url = build.getUrl();
            this.start = new Moment(build.getStartTimeInMillis());
            if (build.isBuilding()) {
                this.duration = Math.max(MomentRange.duration(this.start, CalendarEventFactory.this.now), build.getEstimatedDuration());
                this.state = CalendarEventState.RUNNING;
            } else {
                this.duration = build.getDuration();
                this.state = CalendarEventState.FINISHED;
            }
            this.end = this.initEnd(this.start.getTimeInMillis(), this.duration);
        }

        @Override
        public Run getBuild() {
            return this.build;
        }

        @Override
        public CalendarEventState getState() {
            return this.state;
        }

        @Override
        public String getIconClassName() {
            return "symbol-status-" + this.build.getIconColor().getIconName();
        }

        @Override
        public StartedCalendarEvent getPreviousStartedEvent() {
            if (this.previousEvent == null && this.build != null) {
                this.previousEvent = CalendarEventFactory.this.calendarEventService.getPreviousEvent(this);
            }
            return this.previousEvent;
        }

        @Override
        public StartedCalendarEvent getNextStartedEvent() {
            if (this.nextEvent == null && this.build != null) {
                this.nextEvent = CalendarEventFactory.this.calendarEventService.getNextEvent(this);
            }
            return this.nextEvent;
        }

        @Override
        public ScheduledCalendarEvent getNextScheduledEvent(CalendarView.CalendarViewEventsType eventsType) {
            if (this.nextScheduledEvent == null && this.build != null) {
                this.nextScheduledEvent = CalendarEventFactory.this.calendarEventService.getNextScheduledEvent(this, eventsType);
            }
            return this.nextScheduledEvent;
        }
    }

    private abstract class CalendarEventImpl
    implements CalendarEvent {
        protected String id;
        protected Job job;
        protected Moment start;
        protected Moment end;
        protected String title;
        protected String url;
        protected long duration;
        private transient List<StartedCalendarEvent> lastEvents;

        private CalendarEventImpl() {
        }

        final String initId(String url, long startTimeInMillis) {
            return StringUtils.defaultString((String)url, (String)"").replace("/", "-").toLowerCase(Locale.ENGLISH) + startTimeInMillis;
        }

        final Moment initEnd(long timeInMillis, long duration) {
            long dur = duration < 1000L ? 1000L : duration;
            Calendar end = Calendar.getInstance();
            end.setTimeInMillis(timeInMillis);
            end.add(13, (int)(dur / 1000L));
            return new Moment(end);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Job getJob() {
            return this.job;
        }

        @Override
        public Moment getStart() {
            return this.start;
        }

        @Override
        public Moment getEnd() {
            return this.end;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public long getDuration() {
            return this.duration;
        }

        @Override
        public String getTimestampString() {
            long now = new GregorianCalendar().getTimeInMillis();
            long difference = Math.abs(now - this.start.getTimeInMillis());
            return Util.getPastTimeString((long)difference);
        }

        @Override
        public String getDurationString() {
            return Util.getTimeSpanString((long)this.duration);
        }

        @Override
        public boolean isInRange(MomentRange range) {
            return this.start.compareTo(range.getStart()) >= 0 && this.start.compareTo(range.getEnd()) < 0 || this.end.compareTo(range.getStart()) > 0 && this.end.compareTo(range.getEnd()) < 0 || this.start.compareTo(range.getStart()) <= 0 && this.end.compareTo(range.getEnd()) >= 0;
        }

        public String toString() {
            return DateUtil.formatDateTime(this.start.getTime()) + " - " + DateUtil.formatDateTime(this.end.getTime()) + ": " + this.getTitle();
        }

        @Override
        public List<StartedCalendarEvent> getLastEvents() {
            if (this.lastEvents == null) {
                this.lastEvents = CalendarEventFactory.this.calendarEventService.getLastEvents(this, 5);
            }
            return this.lastEvents;
        }
    }
}

