/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.TopLevelItem;
import io.jenkins.plugins.view.calendar.Messages;
import io.jenkins.plugins.view.calendar.event.CalendarEvent;
import io.jenkins.plugins.view.calendar.service.CalendarEventService;
import io.jenkins.plugins.view.calendar.service.CronJobService;
import io.jenkins.plugins.view.calendar.time.Moment;
import io.jenkins.plugins.view.calendar.time.MomentRange;
import io.jenkins.plugins.view.calendar.util.FieldUtil;
import io.jenkins.plugins.view.calendar.util.RequestUtil;
import io.jenkins.plugins.view.calendar.util.ValidationUtil;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
public class CalendarView
extends ListView {
    private CalendarViewEventsType calendarViewEventsType;
    private CalendarViewType calendarViewType;
    private Boolean useCustomFormats;
    private Boolean useCustomWeekSettings;
    private Boolean useCustomSlotSettings;
    private Boolean weekSettingsShowWeekends;
    private Boolean weekSettingsShowWeekNumbers;
    private Integer weekSettingsFirstDay;
    private String monthTitleFormat;
    private String monthColumnHeaderFormat;
    private String monthTimeFormat;
    private String monthPopupBuildTimeFormat;
    private String weekTitleFormat;
    private String weekColumnHeaderFormat;
    private String weekTimeFormat;
    private String weekSlotTimeFormat;
    private String weekPopupBuildTimeFormat;
    private String dayTitleFormat;
    private String dayColumnHeaderFormat;
    private String dayTimeFormat;
    private String daySlotTimeFormat;
    private String dayPopupBuildTimeFormat;
    private String weekSlotDuration;
    private String weekMinTime;
    private String weekMaxTime;
    private String daySlotDuration;
    private String dayMinTime;
    private String dayMaxTime;

    @DataBoundConstructor
    public CalendarView(String name) {
        super(name);
    }

    public CalendarViewEventsType getCalendarViewEventsType() {
        return FieldUtil.defaultIfNull(this.calendarViewEventsType, CalendarViewEventsType.ALL);
    }

    public void setCalendarViewEventsType(CalendarViewEventsType calendarViewEventsType) {
        this.calendarViewEventsType = calendarViewEventsType;
    }

    public CalendarViewType getCalendarViewType() {
        return FieldUtil.defaultIfNull(this.calendarViewType, CalendarViewType.WEEK);
    }

    public void setCalendarViewType(CalendarViewType calendarViewType) {
        this.calendarViewType = calendarViewType;
    }

    public boolean isUseCustomFormats() {
        return FieldUtil.defaultIfNull(this.useCustomFormats, false);
    }

    public void setUseCustomFormats(boolean useCustomFormats) {
        this.useCustomFormats = useCustomFormats;
    }

    public boolean isUseCustomWeekSettings() {
        return FieldUtil.defaultIfNull(this.useCustomWeekSettings, false);
    }

    public void setUseCustomWeekSettings(boolean useCustomWeekSettings) {
        this.useCustomWeekSettings = useCustomWeekSettings;
    }

    public boolean isUseCustomSlotSettings() {
        return FieldUtil.defaultIfNull(this.useCustomSlotSettings, false);
    }

    public void setUseCustomSlotSettings(boolean useCustomSlotSettings) {
        this.useCustomSlotSettings = useCustomSlotSettings;
    }

    public boolean isWeekSettingsShowWeekends() {
        return FieldUtil.defaultIfNull(this.weekSettingsShowWeekends, true);
    }

    public void setWeekSettingsShowWeekends(boolean weekSettingsShowWeekends) {
        this.weekSettingsShowWeekends = weekSettingsShowWeekends;
    }

    public boolean isWeekSettingsShowWeekNumbers() {
        return FieldUtil.defaultIfNull(this.weekSettingsShowWeekNumbers, true);
    }

    public void setWeekSettingsShowWeekNumbers(boolean weekSettingsShowWeekNumbers) {
        this.weekSettingsShowWeekNumbers = weekSettingsShowWeekNumbers;
    }

    public int getWeekSettingsFirstDay() {
        return FieldUtil.defaultIfNull(this.weekSettingsFirstDay, 1);
    }

    public void setWeekSettingsFirstDay(int weekSettingsFirstDay) {
        this.weekSettingsFirstDay = weekSettingsFirstDay;
    }

    public String getMonthTitleFormat() {
        return FieldUtil.defaultIfNull(this.monthTitleFormat, "");
    }

    public void setMonthTitleFormat(String monthTitleFormat) {
        this.monthTitleFormat = monthTitleFormat;
    }

    public String getMonthColumnHeaderFormat() {
        return FieldUtil.defaultIfNull(this.monthColumnHeaderFormat, "");
    }

    public void setMonthColumnHeaderFormat(String monthColumnHeaderFormat) {
        this.monthColumnHeaderFormat = monthColumnHeaderFormat;
    }

    public String getMonthTimeFormat() {
        return FieldUtil.defaultIfNull(this.monthTimeFormat, "");
    }

    public void setMonthTimeFormat(String monthTimeFormat) {
        this.monthTimeFormat = monthTimeFormat;
    }

    public String getMonthPopupBuildTimeFormat() {
        return FieldUtil.defaultIfNull(this.monthPopupBuildTimeFormat, "");
    }

    public void setMonthPopupBuildTimeFormat(String monthPopupBuildTimeFormat) {
        this.monthPopupBuildTimeFormat = monthPopupBuildTimeFormat;
    }

    public String getWeekTitleFormat() {
        return FieldUtil.defaultIfNull(this.weekTitleFormat, "");
    }

    public void setWeekTitleFormat(String weekTitleFormat) {
        this.weekTitleFormat = weekTitleFormat;
    }

    public String getWeekColumnHeaderFormat() {
        return FieldUtil.defaultIfNull(this.weekColumnHeaderFormat, "");
    }

    public void setWeekColumnHeaderFormat(String weekColumnHeaderFormat) {
        this.weekColumnHeaderFormat = weekColumnHeaderFormat;
    }

    public String getWeekTimeFormat() {
        return FieldUtil.defaultIfNull(this.weekTimeFormat, "");
    }

    public void setWeekTimeFormat(String weekTimeFormat) {
        this.weekTimeFormat = weekTimeFormat;
    }

    public String getWeekSlotTimeFormat() {
        return FieldUtil.defaultIfNull(this.weekSlotTimeFormat, "");
    }

    public void setWeekSlotTimeFormat(String weekSlotTimeFormat) {
        this.weekSlotTimeFormat = weekSlotTimeFormat;
    }

    public String getWeekPopupBuildTimeFormat() {
        return FieldUtil.defaultIfNull(this.weekPopupBuildTimeFormat, "");
    }

    public void setWeekPopupBuildTimeFormat(String weekPopupBuildTimeFormat) {
        this.weekPopupBuildTimeFormat = weekPopupBuildTimeFormat;
    }

    public String getDayTitleFormat() {
        return FieldUtil.defaultIfNull(this.dayTitleFormat, "");
    }

    public void setDayTitleFormat(String dayTitleFormat) {
        this.dayTitleFormat = dayTitleFormat;
    }

    public String getDayColumnHeaderFormat() {
        return FieldUtil.defaultIfNull(this.dayColumnHeaderFormat, "");
    }

    public void setDayColumnHeaderFormat(String dayColumnHeaderFormat) {
        this.dayColumnHeaderFormat = dayColumnHeaderFormat;
    }

    public String getDayTimeFormat() {
        return FieldUtil.defaultIfNull(this.dayTimeFormat, "");
    }

    public void setDayTimeFormat(String dayTimeFormat) {
        this.dayTimeFormat = dayTimeFormat;
    }

    public String getDaySlotTimeFormat() {
        return FieldUtil.defaultIfNull(this.daySlotTimeFormat, "");
    }

    public void setDaySlotTimeFormat(String daySlotTimeFormat) {
        this.daySlotTimeFormat = daySlotTimeFormat;
    }

    public String getDayPopupBuildTimeFormat() {
        return FieldUtil.defaultIfNull(this.dayPopupBuildTimeFormat, "");
    }

    public void setDayPopupBuildTimeFormat(String dayPopupBuildTimeFormat) {
        this.dayPopupBuildTimeFormat = dayPopupBuildTimeFormat;
    }

    public String getWeekSlotDuration() {
        return FieldUtil.defaultIfNull(this.weekSlotDuration, "00:30:00");
    }

    public void setWeekSlotDuration(String weekSlotDuration) {
        this.weekSlotDuration = weekSlotDuration;
    }

    public String getDaySlotDuration() {
        return FieldUtil.defaultIfNull(this.daySlotDuration, "00:30:00");
    }

    public void setDaySlotDuration(String daySlotDuration) {
        this.daySlotDuration = daySlotDuration;
    }

    public String getWeekMinTime() {
        return FieldUtil.defaultIfNull(this.weekMinTime, "00:00:00");
    }

    public void setWeekMinTime(String weekMinTime) {
        this.weekMinTime = weekMinTime;
    }

    public String getWeekMaxTime() {
        return FieldUtil.defaultIfNull(this.weekMaxTime, "24:00:00");
    }

    public void setWeekMaxTime(String weekMaxTime) {
        this.weekMaxTime = weekMaxTime;
    }

    public String getDayMinTime() {
        return FieldUtil.defaultIfNull(this.dayMinTime, "00:00:00");
    }

    public void setDayMinTime(String dayMinTime) {
        this.dayMinTime = dayMinTime;
    }

    public String getDayMaxTime() {
        return FieldUtil.defaultIfNull(this.dayMaxTime, "24:00:00");
    }

    public void setDayMaxTime(String dayMaxTime) {
        this.dayMaxTime = dayMaxTime;
    }

    public boolean isAutomaticRefreshEnabled() {
        return false;
    }

    protected void submit(StaplerRequest2 req) throws ServletException, Descriptor.FormException, IOException {
        this.validate(req);
        super.submit(req);
        this.updateFields(req);
    }

    private void validate(StaplerRequest2 req) throws Descriptor.FormException {
        List<String> validSlotDurations = Collections.unmodifiableList(Arrays.asList("00:05:00", "00:10:00", "00:15:00", "00:20:00", "00:30:00", "01:00:00"));
        Pattern validDateTimePattern = Pattern.compile("(0[0-9]|1[0-9]|2[0-4]):00:00");
        ValidationUtil.validateEnum(req, "calendarViewEventsType", CalendarViewEventsType.class);
        ValidationUtil.validateEnum(req, "calendarViewType", CalendarViewType.class);
        ValidationUtil.validateRange(req, "weekSettingsFirstDay", 0, 7);
        ValidationUtil.validateInList(req, "weekSlotDuration", validSlotDurations);
        ValidationUtil.validatePattern(req, "weekMinTime", validDateTimePattern);
        ValidationUtil.validatePattern(req, "weekMaxTime", validDateTimePattern);
        ValidationUtil.validateInList(req, "daySlotDuration", validSlotDurations);
        ValidationUtil.validatePattern(req, "dayMinTime", validDateTimePattern);
        ValidationUtil.validatePattern(req, "dayMaxTime", validDateTimePattern);
    }

    private void updateFields(StaplerRequest2 req) {
        this.setCalendarViewEventsType(CalendarViewEventsType.valueOf(req.getParameter("calendarViewEventsType")));
        this.setCalendarViewType(CalendarViewType.valueOf(req.getParameter("calendarViewType")));
        this.setUseCustomFormats(req.getParameter("useCustomFormats") != null);
        this.setUseCustomWeekSettings(req.getParameter("useCustomWeekSettings") != null);
        this.setUseCustomSlotSettings(req.getParameter("useCustomSlotSettings") != null);
        this.setWeekSettingsShowWeekends(req.getParameter("weekSettingsShowWeekends") != null);
        this.setWeekSettingsShowWeekNumbers(req.getParameter("weekSettingsShowWeekNumbers") != null);
        this.setWeekSettingsFirstDay(Integer.parseInt(req.getParameter("weekSettingsFirstDay")));
        this.setMonthTitleFormat(req.getParameter("monthTitleFormat"));
        this.setMonthColumnHeaderFormat(req.getParameter("monthColumnHeaderFormat"));
        this.setMonthTimeFormat(req.getParameter("monthTimeFormat"));
        this.setMonthPopupBuildTimeFormat(req.getParameter("monthPopupBuildTimeFormat"));
        this.setWeekTitleFormat(req.getParameter("weekTitleFormat"));
        this.setWeekColumnHeaderFormat(req.getParameter("weekColumnHeaderFormat"));
        this.setWeekTimeFormat(req.getParameter("weekTimeFormat"));
        this.setWeekSlotTimeFormat(req.getParameter("weekSlotTimeFormat"));
        this.setWeekPopupBuildTimeFormat(req.getParameter("weekPopupBuildTimeFormat"));
        this.setDayTitleFormat(req.getParameter("dayTitleFormat"));
        this.setDayColumnHeaderFormat(req.getParameter("dayColumnHeaderFormat"));
        this.setDayTimeFormat(req.getParameter("dayTimeFormat"));
        this.setDaySlotTimeFormat(req.getParameter("daySlotTimeFormat"));
        this.setDayPopupBuildTimeFormat(req.getParameter("dayPopupBuildTimeFormat"));
        this.setWeekSlotDuration(req.getParameter("weekSlotDuration"));
        this.setWeekMinTime(req.getParameter("weekMinTime"));
        this.setWeekMaxTime(req.getParameter("weekMaxTime"));
        this.setDaySlotDuration(req.getParameter("daySlotDuration"));
        this.setDayMinTime(req.getParameter("dayMinTime"));
        this.setDayMaxTime(req.getParameter("dayMaxTime"));
    }

    public List<Job> getJobs() {
        List items = this.getItems();
        ArrayList<Job> jobs = new ArrayList<Job>(items.size());
        for (TopLevelItem item : items) {
            if (!(item instanceof Job)) continue;
            jobs.add((Job)item);
        }
        return jobs;
    }

    public List<CalendarEvent> getEvents() throws ParseException {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        Calendar start = RequestUtil.getParamAsCalendar(req, "start");
        Calendar end = RequestUtil.getParamAsCalendar(req, "end");
        Moment now = new Moment();
        return new CalendarEventService(now, new CronJobService(now)).getCalendarEvents(this.getJobs(), MomentRange.range(start, end), this.getCalendarViewEventsType());
    }

    public String jsonEscape(String text) {
        return StringEscapeUtils.escapeJavaScript((String)text);
    }

    public static enum CalendarViewEventsType {
        ALL,
        BUILDS,
        POLLINGS;

    }

    public static enum CalendarViewType {
        MONTH,
        WEEK,
        DAY;

    }

    @Extension
    public static final class DescriptorImpl
    extends ListView.DescriptorImpl {
        public String getDisplayName() {
            return Messages.CalendarView_DisplayName();
        }
    }
}

