/*
 * Decompiled with CFR 0.152.
 */
package com.buildstash;

import com.buildstash.BuildstashUploadRequest;
import hudson.EnvVars;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionControlDetector {
    public static void populateVersionControlInfo(Run<?, ?> build, BuildstashUploadRequest request) {
        VersionControlDetector.populateVersionControlInfo(build, request, null);
    }

    public static void populateVersionControlInfo(Run<?, ?> build, BuildstashUploadRequest request, TaskListener listener) {
        try {
            String detectedBranch;
            String repoUrl;
            SCM scm = null;
            try {
                if (build.getParent() instanceof AbstractProject) {
                    AbstractProject project = (AbstractProject)build.getParent();
                    scm = project.getScm();
                }
            }
            catch (Exception project) {
                // empty catch block
            }
            if (scm == null) {
                VersionControlDetector.populateFromBuildData(build, request, listener);
                return;
            }
            String detectedHostType = VersionControlDetector.detectHostType(scm);
            if (detectedHostType != null && VersionControlDetector.isNullOrBlank(request.getVcHostType())) {
                request.setVcHostType(detectedHostType);
            }
            if ((repoUrl = VersionControlDetector.getRepositoryUrl(build, scm, listener)) != null && !repoUrl.isBlank()) {
                String detectedRepoName;
                String detectedHost = VersionControlDetector.detectHostFromUrl(repoUrl);
                if (detectedHost != null && VersionControlDetector.isNullOrBlank(request.getVcHost())) {
                    request.setVcHost(detectedHost);
                }
                if ((detectedRepoName = VersionControlDetector.extractRepoNameFromUrl(repoUrl)) != null && VersionControlDetector.isNullOrBlank(request.getVcRepoName())) {
                    request.setVcRepoName(detectedRepoName);
                }
                if (VersionControlDetector.isNullOrBlank(request.getVcRepoUrl())) {
                    request.setVcRepoUrl(repoUrl);
                }
            }
            if ((detectedBranch = VersionControlDetector.getBranch(build, scm, listener)) != null && VersionControlDetector.isNullOrBlank(request.getVcBranch())) {
                request.setVcBranch(detectedBranch);
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcCommitSha())) {
                String detectedCommitSha = null;
                if (detectedHostType != null && detectedHostType.equals("svn")) {
                    detectedCommitSha = VersionControlDetector.getSvnRevision(build, scm, listener);
                }
                if (detectedCommitSha == null || detectedCommitSha.isBlank()) {
                    detectedCommitSha = VersionControlDetector.getCommitSha(build, listener);
                }
                if (detectedCommitSha != null && !detectedCommitSha.isBlank()) {
                    request.setVcCommitSha(detectedCommitSha);
                }
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcCommitUrl())) {
                String commitUrl;
                String finalCommitSha = request.getVcCommitSha();
                String finalRepoUrl = request.getVcRepoUrl();
                String finalHostType = request.getVcHostType();
                if (finalCommitSha != null && finalRepoUrl != null && (commitUrl = VersionControlDetector.generateCommitUrl(finalRepoUrl, finalCommitSha, finalHostType)) != null) {
                    request.setVcCommitUrl(commitUrl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isNullOrBlank(String str) {
        return str == null || str.isBlank();
    }

    private static void populateFromBuildData(Run<?, ?> build, BuildstashUploadRequest request, TaskListener listener) {
        try {
            String commitSha;
            Object buildData = null;
            Class<?> buildDataClass = null;
            try {
                List actions = build.getAllActions();
                for (Object action : actions) {
                    String actionClass;
                    if (action == null || !(actionClass = action.getClass().getName()).equals("hudson.plugins.git.util.BuildData") && !actionClass.equals("org.jenkinsci.plugins.git.util.BuildData")) continue;
                    buildData = action;
                    buildDataClass = action.getClass();
                    break;
                }
            }
            catch (Exception actions) {
                // empty catch block
            }
            if (buildData == null) {
                try {
                    buildDataClass = Class.forName("hudson.plugins.git.util.BuildData");
                    Method getActionMethod = build.getClass().getMethod("getAction", Class.class);
                    buildData = getActionMethod.invoke(build, buildDataClass);
                }
                catch (Exception getActionMethod) {
                    // empty catch block
                }
            }
            if (buildData == null) {
                return;
            }
            if (buildDataClass == null) {
                buildDataClass = buildData.getClass();
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcRepoUrl())) {
                try {
                    Method getRemoteUrls = buildDataClass.getMethod("getRemoteUrls", new Class[0]);
                    Object remoteUrls = getRemoteUrls.invoke(buildData, new Object[0]);
                    if (remoteUrls != null) {
                        Map map;
                        String repoUrl = null;
                        if (remoteUrls instanceof Collection) {
                            Collection collection = (Collection)remoteUrls;
                            if (!collection.isEmpty()) {
                                Object firstElement = collection.iterator().next();
                                repoUrl = firstElement != null ? firstElement.toString() : null;
                            }
                        } else if (remoteUrls instanceof Map && !(map = (Map)remoteUrls).isEmpty()) {
                            Object firstValue = map.values().iterator().next();
                            String string = repoUrl = firstValue != null ? firstValue.toString() : null;
                            if (repoUrl == null || repoUrl.isBlank()) {
                                Object firstKey = map.keySet().iterator().next();
                                String string2 = repoUrl = firstKey != null ? firstKey.toString() : null;
                            }
                        }
                        if (repoUrl != null && !repoUrl.isBlank()) {
                            String repoName;
                            String host;
                            request.setVcRepoUrl(repoUrl);
                            if (VersionControlDetector.isNullOrBlank(request.getVcHost()) && (host = VersionControlDetector.detectHostFromUrl(repoUrl)) != null) {
                                request.setVcHost(host);
                            }
                            if (VersionControlDetector.isNullOrBlank(request.getVcRepoName()) && (repoName = VersionControlDetector.extractRepoNameFromUrl(repoUrl)) != null) {
                                request.setVcRepoName(repoName);
                            }
                        }
                    }
                }
                catch (Exception getRemoteUrls) {
                    // empty catch block
                }
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcBranch())) {
                try {
                    Map map;
                    Method getBuildsByBranchName = buildDataClass.getMethod("getBuildsByBranchName", new Class[0]);
                    Object buildsByBranch = getBuildsByBranchName.invoke(buildData, new Object[0]);
                    if (buildsByBranch != null && buildsByBranch instanceof Map && !(map = (Map)buildsByBranch).isEmpty()) {
                        String branchName;
                        Object firstKey = map.keySet().iterator().next();
                        String string = branchName = firstKey != null ? firstKey.toString() : null;
                        if (branchName != null && !branchName.isBlank()) {
                            branchName = branchName.replaceAll("^refs/remotes/origin/", "").replaceAll("^refs/heads/", "").replaceAll("^origin/", "").replaceAll("^remotes/origin/", "").replaceAll("^\\*/", "").replaceAll("^\\*", "");
                            request.setVcBranch(branchName);
                        }
                    }
                }
                catch (Exception getBuildsByBranchName) {
                    // empty catch block
                }
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcCommitSha()) && (commitSha = VersionControlDetector.getCommitSha(build, listener)) != null && !commitSha.isBlank()) {
                request.setVcCommitSha(commitSha);
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcCommitUrl())) {
                String commitUrl;
                String finalCommitSha = request.getVcCommitSha();
                String finalRepoUrl = request.getVcRepoUrl();
                String finalHostType = request.getVcHostType();
                if (finalCommitSha != null && finalRepoUrl != null && (commitUrl = VersionControlDetector.generateCommitUrl(finalRepoUrl, finalCommitSha, finalHostType)) != null) {
                    request.setVcCommitUrl(commitUrl);
                }
            }
            if (VersionControlDetector.isNullOrBlank(request.getVcHostType())) {
                request.setVcHostType("git");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String detectHostType(SCM scm) {
        String scmClass = scm.getClass().getName();
        String scmClassLower = scmClass.toLowerCase();
        if (scmClassLower.contains("git")) {
            return "git";
        }
        if (scmClassLower.contains("svn") || scmClassLower.contains("subversion")) {
            return "svn";
        }
        if (scmClassLower.contains("mercurial") || scmClassLower.contains("hg")) {
            return "hg";
        }
        if (scmClassLower.contains("bazaar") || scmClassLower.contains("bzr")) {
            return "bzr";
        }
        if (scmClassLower.contains("perforce")) {
            return "perforce";
        }
        if (scmClassLower.contains("cvs")) {
            return "cvs";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String getRepositoryUrl(Run<?, ?> build, SCM scm, TaskListener listener) {
        block40: {
            String scmClass = scm.getClass().getName();
            try {
                if (scmClass.contains("GitSCM")) {
                    try {
                        Collection collection;
                        Method getUserRemoteConfigs = scm.getClass().getMethod("getUserRemoteConfigs", new Class[0]);
                        Object configs = getUserRemoteConfigs.invoke((Object)scm, new Object[0]);
                        if (!(configs instanceof Collection) || (collection = (Collection)configs).isEmpty()) break block40;
                        Object config = collection.iterator().next();
                        try {
                            Method getUrl = config.getClass().getMethod("getUrl", new Class[0]);
                            String url = (String)getUrl.invoke(config, new Object[0]);
                            if (url != null && !url.isBlank()) {
                                return url;
                            }
                            break block40;
                        }
                        catch (Exception getUrl) {
                        }
                    }
                    catch (Exception getUserRemoteConfigs) {}
                    break block40;
                }
                if (scmClass.contains("Perforce")) {
                    try {
                        try {
                            Method getDepotPath = scm.getClass().getMethod("getDepotPath", new Class[0]);
                            String depotPath = (String)getDepotPath.invoke((Object)scm, new Object[0]);
                            if (depotPath == null || depotPath.isBlank()) break block40;
                            try {
                                Method getP4Port = scm.getClass().getMethod("getP4Port", new Class[0]);
                                String p4Port = (String)getP4Port.invoke((Object)scm, new Object[0]);
                                if (p4Port != null && !p4Port.isBlank()) {
                                    return p4Port + "/" + depotPath;
                                }
                            }
                            catch (Exception getP4Port) {
                                // empty catch block
                            }
                            return depotPath;
                        }
                        catch (Exception e) {
                            try {
                                Method getDepot = scm.getClass().getMethod("getDepot", new Class[0]);
                                String depot = (String)getDepot.invoke((Object)scm, new Object[0]);
                                if (depot != null && !depot.isBlank()) {
                                    return depot;
                                }
                                break block40;
                            }
                            catch (Exception getDepot) {
                            }
                        }
                    }
                    catch (Exception e) {}
                    break block40;
                }
                if (!scmClass.contains("SubversionSCM") && !scmClass.contains("SVN")) break block40;
                try {
                    try {
                        void location;
                        Method getLocations = scm.getClass().getMethod("getLocations", new Class[0]);
                        Object locations = getLocations.invoke((Object)scm, new Object[0]);
                        Object[] locationArray = null;
                        if (locations != null) {
                            if (locations instanceof Collection) {
                                Collection collection = (Collection)locations;
                                if (!collection.isEmpty()) {
                                    locationArray = collection.toArray();
                                }
                            } else if (locations.getClass().isArray()) {
                                int length = Array.getLength(locations);
                                locationArray = new Object[length];
                                for (int i = 0; i < length; ++i) {
                                    locationArray[i] = Array.get(locations, i);
                                }
                            }
                        }
                        if (locationArray == null || locationArray.length <= 0 || (location = locationArray[0]) == null) break block40;
                        try {
                            Method getRemote = location.getClass().getMethod("getRemote", new Class[0]);
                            String url = (String)getRemote.invoke((Object)location, new Object[0]);
                            if (url != null && !url.isBlank()) {
                                return url;
                            }
                        }
                        catch (Exception e) {
                            try {
                                Method getURL = location.getClass().getMethod("getURL", new Class[0]);
                                String url = (String)getURL.invoke((Object)location, new Object[0]);
                                if (url != null && !url.isBlank()) {
                                    return url;
                                }
                            }
                            catch (Exception getURL) {}
                        }
                    }
                    catch (Exception e) {
                        try {
                            Collection collection;
                            Method getModules = scm.getClass().getMethod("getModules", new Class[0]);
                            Object modules = getModules.invoke((Object)scm, new Object[0]);
                            if (!(modules instanceof Collection) || (collection = (Collection)modules).isEmpty()) break block40;
                            Object module = collection.iterator().next();
                            try {
                                Method getURL = module.getClass().getMethod("getURL", new Class[0]);
                                String url = (String)getURL.invoke(module, new Object[0]);
                                if (url != null && !url.isBlank()) {
                                    return url;
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String detectHostFromUrl(String url) {
        if (url == null || url.isBlank()) {
            return null;
        }
        String lowerUrl = url.toLowerCase();
        if (lowerUrl.contains("github.com")) {
            return "github";
        }
        if (lowerUrl.contains("gitlab.com")) {
            return "gitlab";
        }
        if (lowerUrl.contains("gitlab")) {
            return "gitlab-self";
        }
        if (lowerUrl.contains("bitbucket.org")) {
            return "bitbucket";
        }
        if (lowerUrl.contains("azure.com") || lowerUrl.contains("visualstudio.com") || lowerUrl.contains("dev.azure.com")) {
            return "azure-repos";
        }
        if (lowerUrl.contains("gitea")) {
            return "gitea";
        }
        if (lowerUrl.contains("forgejo")) {
            return "forgejo";
        }
        if (lowerUrl.contains("gogs")) {
            return "gogs";
        }
        if (lowerUrl.contains("codeberg")) {
            return "codeberg";
        }
        if (lowerUrl.contains("sourceforge.com")) {
            return "sourceforge";
        }
        if (lowerUrl.contains("sourcehut") || lowerUrl.contains("sr.ht")) {
            return "sourcehut";
        }
        if (lowerUrl.contains("codecommit")) {
            return "aws-codecommit";
        }
        if (lowerUrl.contains("perforce")) {
            return "perforce";
        }
        if (lowerUrl.contains("gitee")) {
            return "gitee";
        }
        if (lowerUrl.contains("svn.riouxsvn.com") || lowerUrl.contains("riouxsvn")) {
            return "riouxsvn";
        }
        if (lowerUrl.contains("assembla.com")) {
            return "assembla";
        }
        return null;
    }

    private static String extractRepoNameFromUrl(String url) {
        block10: {
            if (url == null || url.isBlank()) {
                return null;
            }
            try {
                url = url.replaceAll("\\.git$", "");
                String host = VersionControlDetector.detectHostFromUrl(url);
                String lowerUrl = url.toLowerCase();
                URI uri = new URI(url);
                String path = uri.getPath();
                if (path != null && !path.isEmpty()) {
                    String repoName;
                    int i;
                    String[] parts;
                    String string = path = path.startsWith("/") ? path.substring(1) : path;
                    if ("azure-repos".equals(host) && lowerUrl.contains("/_git/")) {
                        parts = path.split("/");
                        for (i = 0; i < parts.length - 1; ++i) {
                            if (!"_git".equalsIgnoreCase(parts[i]) || (repoName = parts[i + 1]) == null || repoName.isEmpty()) continue;
                            return repoName.split("\\?")[0].split("#")[0];
                        }
                    }
                    if ("bitbucket".equals(host) && (lowerUrl.contains("/scm/") || lowerUrl.contains("/projects/"))) {
                        parts = path.split("/");
                        for (i = parts.length - 1; i >= 0; --i) {
                            if (parts[i].isEmpty() || parts[i].equalsIgnoreCase("scm") || parts[i].equalsIgnoreCase("projects") || parts[i].equalsIgnoreCase("repos")) continue;
                            repoName = parts[i];
                            return repoName.split("\\?")[0].split("#")[0];
                        }
                    }
                    if ((parts = path.split("/")).length > 0) {
                        String repoName2 = parts[parts.length - 1];
                        if (!(repoName2 = repoName2.split("\\?")[0].split("#")[0]).isEmpty()) {
                            return repoName2;
                        }
                    }
                }
            }
            catch (URISyntaxException e) {
                Pattern pattern = Pattern.compile("([^/]+?)(?:\\.git)?(?:[/?#]|$)");
                Matcher matcher = pattern.matcher(url);
                if (!matcher.find()) break block10;
                String repoName = matcher.group(1);
                String[] parts = url.split("/");
                if (parts.length <= 0) break block10;
                repoName = parts[parts.length - 1].replaceAll("\\.git$", "");
                return repoName.split("\\?")[0].split("#")[0];
            }
        }
        return null;
    }

    private static String getBranch(Run<?, ?> build, SCM scm, TaskListener listener) {
        block7: {
            try {
                if (!scm.getClass().getName().contains("GitSCM")) break block7;
                try {
                    Collection branchCollection;
                    Method getBranches = scm.getClass().getMethod("getBranches", new Class[0]);
                    Object branches = getBranches.invoke((Object)scm, new Object[0]);
                    if (!(branches instanceof Collection) || (branchCollection = (Collection)branches).isEmpty()) break block7;
                    Object branchSpec = branchCollection.iterator().next();
                    try {
                        Method getName = branchSpec.getClass().getMethod("getName", new Class[0]);
                        String branchName = (String)getName.invoke(branchSpec, new Object[0]);
                        if (branchName != null && !branchName.isBlank()) {
                            return branchName.replaceAll("^refs/heads/", "").replaceAll("^origin/", "").replaceAll("^\\*/", "").replaceAll("^\\*", "");
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getSvnRevision(Run<?, ?> build, SCM scm, TaskListener listener) {
        try {
            EnvVars env = build.getEnvironment(listener);
            String[] envVars = new String[]{"SVN_REVISION", "SVN_REV", "SVN_REVISION_NUMBER", "SVN_VERSION"};
            for (int i = 0; i < envVars.length; ++i) {
                String envVar = envVars[i];
                String value = (String)env.get((Object)envVar);
                if (value == null || value.isBlank()) continue;
                return value;
            }
        }
        catch (Exception env) {
            // empty catch block
        }
        try {
            String[] methodNames = new String[]{"getRevision", "getRevisionNumber", "getLastRevision", "getCurrentRevision"};
            for (int i = 0; i < methodNames.length; ++i) {
                String methodName = methodNames[i];
                try {
                    String revision;
                    Method method = scm.getClass().getMethod(methodName, new Class[0]);
                    Object result = method.invoke((Object)scm, new Object[0]);
                    if (result == null || (revision = result.toString()) == null || revision.isBlank()) continue;
                    return revision;
                }
                catch (NoSuchMethodException method) {
                    continue;
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
        }
        catch (Exception methodNames) {
            // empty catch block
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String displayName = build.getDisplayName();
            if (displayName != null && (matcher = (pattern = Pattern.compile("r(\\d+)")).matcher(displayName)).find()) {
                String revision = matcher.group(1);
                return revision;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getCommitSha(Run<?, ?> build, TaskListener listener) {
        String revision;
        Object revisionObj;
        Method getRevision3;
        block28: {
            try {
                Method getChangeSetMethod = build.getClass().getMethod("getChangeSet", new Class[0]);
                ChangeLogSet changeSet = (ChangeLogSet)getChangeSetMethod.invoke(build, new Object[0]);
                if (changeSet == null || changeSet.isEmptySet()) break block28;
                for (ChangeLogSet.Entry entry : changeSet) {
                    if (entry == null) continue;
                    try {
                        getRevision3 = entry.getClass().getMethod("getRevision", new Class[0]);
                        revisionObj = getRevision3.invoke((Object)entry, new Object[0]);
                        if (revisionObj != null && (revision = revisionObj.toString()) != null && !revision.isBlank()) {
                            return revision;
                        }
                    }
                    catch (Exception getRevision2) {}
                    break;
                }
            }
            catch (Exception getChangeSetMethod) {
                // empty catch block
            }
        }
        try {
            List actions = build.getAllActions();
            for (Object action : actions) {
                if (action == null) continue;
                String actionClass = action.getClass().getName();
                if (actionClass.equals("hudson.scm.SVNRevisionState")) {
                    try {
                        try {
                            getRevision3 = null;
                            try {
                                getRevision3 = action.getClass().getMethod("getRevision", new Class[0]);
                            }
                            catch (NoSuchMethodException e) {
                                Method[] methods;
                                for (Method m : methods = action.getClass().getMethods()) {
                                    if (!m.getName().equals("getRevision")) continue;
                                    getRevision3 = m;
                                    break;
                                }
                            }
                            if (getRevision3 != null) {
                                revisionObj = null;
                                if (getRevision3.getParameterCount() == 0) {
                                    revisionObj = getRevision3.invoke(action, new Object[0]);
                                } else {
                                    Object[] params = new Object[getRevision3.getParameterCount()];
                                    revisionObj = getRevision3.invoke(action, params);
                                }
                                if (revisionObj != null && (revision = revisionObj.toString()) != null && !revision.isBlank()) {
                                    return revision;
                                }
                            }
                        }
                        catch (Exception getRevision3) {
                            // empty catch block
                        }
                        try {
                            Method getRevisionNumber = action.getClass().getMethod("getRevisionNumber", new Class[0]);
                            revisionObj = getRevisionNumber.invoke(action, new Object[0]);
                            if (revisionObj != null && (revision = revisionObj.toString()) != null && !revision.isBlank()) {
                                return revision;
                            }
                        }
                        catch (Exception getRevisionNumber) {}
                    }
                    catch (Exception getRevisionNumber) {
                        // empty catch block
                    }
                }
                if (!actionClass.contains("BuildData")) continue;
                try {
                    Method getLastBuiltRevision = action.getClass().getMethod("getLastBuiltRevision", new Class[0]);
                    Object revision2 = getLastBuiltRevision.invoke(action, new Object[0]);
                    if (revision2 == null) continue;
                    try {
                        Method getSha1String = revision2.getClass().getMethod("getSha1String", new Class[0]);
                        String sha = (String)getSha1String.invoke(revision2, new Object[0]);
                        if (sha == null || sha.isBlank()) continue;
                        return sha;
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String extractPerforceRepoName(String depotPath) {
        if (depotPath == null || depotPath.isBlank()) {
            return null;
        }
        String path = depotPath.startsWith("//") ? depotPath.substring(2) : depotPath;
        String[] parts = path.split("/");
        if (parts.length > 0) {
            for (int i = parts.length - 1; i >= 0; --i) {
                String part = parts[i];
                if (part.isEmpty() || part.equalsIgnoreCase("depot") || part.equalsIgnoreCase("streams") || part.equalsIgnoreCase("main")) continue;
                return part;
            }
            if (parts.length > 0) {
                return parts[parts.length - 1];
            }
        }
        return null;
    }

    private static String generateCommitUrl(String repoUrl, String commitSha, String hostType) {
        if (repoUrl == null || commitSha == null) {
            return null;
        }
        try {
            String baseUrl = repoUrl.replaceAll("\\.git$", "").replaceAll("/+$", "");
            String host = VersionControlDetector.detectHostFromUrl(repoUrl);
            if (host == null) {
                if (hostType != null && !hostType.isBlank() && "svn".equals(hostType) && commitSha.matches("^\\d+$")) {
                    return null;
                }
                return null;
            }
            if ("github".equals(host)) {
                return baseUrl + "/commit/" + commitSha;
            }
            if ("gitlab".equals(host) || "gitlab-self".equals(host)) {
                return baseUrl + "/-/commit/" + commitSha;
            }
            if ("bitbucket".equals(host)) {
                return baseUrl + "/commits/" + commitSha;
            }
            if ("gitea".equals(host) || "forgejo".equals(host) || "gogs".equals(host) || "codeberg".equals(host)) {
                return baseUrl + "/commit/" + commitSha;
            }
            if ("sourcehut".equals(host)) {
                return baseUrl + "/commit/" + commitSha;
            }
            if ("azure-repos".equals(host)) {
                return baseUrl + "/commit/" + commitSha;
            }
            if ("gitee".equals(host)) {
                return baseUrl + "/commit/" + commitSha;
            }
            if ("sourceforge".equals(host)) {
                if (commitSha.matches("^\\d+$")) {
                    return baseUrl + "/" + commitSha + "/";
                }
                return baseUrl + "/ci/" + commitSha + "/";
            }
            if ("svn".equals(hostType) || host != null && host.contains("svn") ? commitSha.matches("^\\d+$") : "perforce".equals(host)) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

