/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorException;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksEventType;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractPostWebhookProcessor
implements BitbucketWebhookProcessor {
    private static final String SERVER_URL_PARAMETER = "server_url";
    private static final String EVENT_TYPE_HEADER = "X-Event-Key";

    AbstractPostWebhookProcessor() {
    }

    public boolean canHandle(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        if (headers.containsKey(EVENT_TYPE_HEADER) && headers.containsKey("X-Bitbucket-Type") && parameters.containsKey((Object)SERVER_URL_PARAMETER)) {
            PostWebhooksEventType eventType = PostWebhooksEventType.fromHeader(headers.get(EVENT_TYPE_HEADER));
            return eventType != null && this.getSupportedEvents().contains((Object)eventType);
        }
        return false;
    }

    protected abstract List<PostWebhooksEventType> getSupportedEvents();

    @NonNull
    public String getServerURL(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        String serverURL = parameters.get((Object)SERVER_URL_PARAMETER).stream().findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)serverURL)) {
            throw new BitbucketWebhookProcessorException(400, "server_url query parameter not found or empty. Refer to the user documentation on how configure the webHook in Bitbucket at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc#webhooks-registering");
        }
        return serverURL;
    }

    @NonNull
    public String getEventType(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        String eventType = headers.get(EVENT_TYPE_HEADER);
        if (StringUtils.isEmpty((CharSequence)eventType)) {
            throw new IllegalStateException("X-Event-Key is missing or empty, this processor should not proceed after canHandle method. Please fill an issue at https://issues.jenkins.io reporting this stacktrace.");
        }
        return eventType;
    }

    public void verifyPayload(Map<String, String> headers, String payload, BitbucketEndpoint endpoint) throws BitbucketWebhookProcessorException {
    }

    @NonNull
    protected String getOrigin(Map<String, Object> context) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)context.get("origin"), "unknow"});
    }
}

