/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.supplier;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class ParallelSupplier<T>
implements Supplier<Collection<T>> {
    private final Collection<Supplier<T>> suppliers;

    ParallelSupplier(Collection<Supplier<T>> suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    public Collection<T> get() {
        Collection supplierFutures = this.suppliers.stream().map(CompletableFuture::supplyAsync).collect(Collectors.toList());
        CompletableFuture<Collection<T>> future = ParallelSupplier.flip(supplierFutures);
        return future.join();
    }

    private static <T> CompletableFuture<Collection<T>> flip(Collection<CompletableFuture<T>> futures) {
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return allDoneFuture.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }
}

