/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config.transformer.name;

import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.NameTransformer;
import io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.PrefixRemover;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RemovePrefix
extends NameTransformer {
    private String prefix;

    @DataBoundConstructor
    public RemovePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String transform(String str) {
        return PrefixRemover.removePrefix(this.prefix).from(str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovePrefix that = (RemovePrefix)o;
        return Objects.equals(this.prefix, that.prefix);
    }

    public int hashCode() {
        return Objects.hash(this.prefix);
    }

    @Extension
    @Symbol(value={"removePrefix"})
    public static class DescriptorImpl
    extends NameTransformer.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return Messages.removePrefix();
        }

        public FormValidation doCheckPrefix(@QueryParameter String prefix) {
            if (Util.fixEmptyAndTrim((String)prefix) == null) {
                return FormValidation.warning((String)"Prefix should not be empty");
            }
            return FormValidation.ok();
        }
    }
}

