/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class EndpointConfiguration
extends AbstractDescribableImpl<EndpointConfiguration>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceEndpoint;
    private String signingRegion;

    @DataBoundConstructor
    public EndpointConfiguration(String serviceEndpoint, String signingRegion) {
        this.serviceEndpoint = serviceEndpoint;
        this.signingRegion = signingRegion;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public String getSigningRegion() {
        return this.signingRegion;
    }

    @DataBoundSetter
    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    @DataBoundSetter
    public void setSigningRegion(String signingRegion) {
        this.signingRegion = signingRegion;
    }

    public String toString() {
        return "Service Endpoint = " + this.serviceEndpoint + ", Signing Region = " + this.signingRegion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointConfiguration that = (EndpointConfiguration)o;
        return Objects.equals(this.serviceEndpoint, that.serviceEndpoint) && Objects.equals(this.signingRegion, that.signingRegion);
    }

    public int hashCode() {
        return Objects.hash(this.serviceEndpoint, this.signingRegion);
    }

    public AwsClientBuilder.EndpointConfiguration build() {
        if (this.serviceEndpoint == null || this.signingRegion == null) {
            return null;
        }
        return new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.signingRegion);
    }

    @Extension
    @Symbol(value={"endpointConfiguration"})
    public static class DescriptorImpl
    extends Descriptor<EndpointConfiguration> {
        @Nonnull
        public String getDisplayName() {
            return Messages.endpointConfiguration();
        }

        public ListBoxModel doFillSigningRegionItems() {
            ListBoxModel regions = new ListBoxModel();
            regions.add("", "");
            for (Regions s : Regions.values()) {
                regions.add(s.getDescription(), s.getName());
            }
            return regions;
        }
    }
}

