/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactory_artifacts;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.DescribableList;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryArtifactManagerFactory;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryGenericArtifactConfig;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import jenkins.model.ArtifactManagerConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;

public final class Utils {
    private Utils() {
    }

    @Nullable
    public static ArtifactoryGenericArtifactConfig getArtifactConfig() {
        ArtifactManagerConfiguration artifactManagerConfiguration = ArtifactManagerConfiguration.get();
        DescribableList artifactManagerFactories = artifactManagerConfiguration.getArtifactManagerFactories();
        ArtifactoryArtifactManagerFactory artifactoryArtifactManagerFactory = (ArtifactoryArtifactManagerFactory)artifactManagerFactories.get(ArtifactoryArtifactManagerFactory.class);
        if (artifactoryArtifactManagerFactory == null) {
            return null;
        }
        return artifactoryArtifactManagerFactory.getConfig();
    }

    @Nullable
    public static StandardUsernamePasswordCredentials getCredentials() {
        ArtifactoryGenericArtifactConfig config = Utils.getArtifactConfig();
        if (config == null) {
            return null;
        }
        return Utils.getCredentials(config);
    }

    public static StandardUsernamePasswordCredentials getCredentials(String credentialsId) {
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}));
    }

    public static StandardUsernamePasswordCredentials getCredentials(ArtifactoryGenericArtifactConfig config) {
        return Utils.getCredentials(config.getStorageCredentialId());
    }

    static String urlEncodeParts(String s) {
        return URLEncoder.encode(s.replaceAll(" /", "/").replaceAll("/ ", "/"), StandardCharsets.UTF_8).replace("%2F", "/").replace("+", "%20");
    }

    public static String getUrl(String name) {
        return String.format("%s/%s/%s", Utils.getArtifactConfig().getServerUrl(), Utils.getArtifactConfig().getRepository(), Utils.urlEncodeParts(name));
    }

    public static String stripTrailingSlash(String key) {
        String localKey = key;
        if (key.endsWith("/")) {
            localKey = localKey.substring(0, localKey.length() - 1);
        }
        return localKey;
    }

    public static String getFilePath(String key, String path) {
        return String.format("%s%s/%s", Utils.getArtifactConfig().getPrefix(), key, path);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NonNull
    public static String getPath(String prefix, @NonNull Path filePath) {
        String defaultPrefix = StringUtils.isBlank((CharSequence)prefix) ? "" : (prefix.endsWith("/") ? prefix : String.format("%s/", prefix));
        return String.format("%s%s", defaultPrefix, filePath.getFileName().toString());
    }
}

