/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactory_artifacts;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryAbstractVirtualFile;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryClient;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryGenericArtifactConfig;
import io.jenkins.plugins.artifactory_artifacts.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import jenkins.util.VirtualFile;
import org.jfrog.artifactory.client.model.AqlItemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactoryVirtualFile
extends ArtifactoryAbstractVirtualFile {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryVirtualFile.class);
    private final String key;
    private final transient Run<?, ?> build;
    private final ArtifactoryClient.FileInfo fileInfo;

    public ArtifactoryVirtualFile(String key, Run<?, ?> build) {
        this.key = key;
        this.build = build;
        this.fileInfo = null;
    }

    public ArtifactoryVirtualFile(ArtifactoryClient.FileInfo fileInfo, Run<?, ?> build) {
        this.key = fileInfo.getPath();
        this.build = build;
        this.fileInfo = fileInfo;
    }

    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getName() {
        String localKey = Utils.stripTrailingSlash(this.key);
        int lastSlash = (localKey = localKey.replaceFirst(".*/artifacts/", "")).lastIndexOf(47);
        String result = lastSlash >= 0 ? localKey.substring(lastSlash + 1) : localKey;
        return result;
    }

    @NonNull
    public URI toURI() {
        try {
            return new URI(Utils.getUrl(this.key));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckForNull
    public URL toExternalURL() throws IOException {
        return new URL(Utils.getUrl(this.key));
    }

    public VirtualFile getParent() {
        return new ArtifactoryVirtualFile(this.key.replaceFirst("/[^/]+$", ""), this.build);
    }

    public boolean isDirectory() throws IOException {
        boolean bl;
        block10: {
            if (this.fileInfo != null) {
                return this.fileInfo.isDirectory();
            }
            String keyWithNoSlash = Utils.stripTrailingSlash(this.key);
            if (keyWithNoSlash.endsWith("/*view*")) {
                return false;
            }
            ArtifactoryClient client = this.buildArtifactoryClient();
            try {
                bl = client.isFolder(this.key);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Failed to check if %s is a directory", this.key), (Throwable)e);
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean isFile() throws IOException {
        boolean bl;
        block10: {
            if (this.fileInfo != null) {
                return this.fileInfo.isFile();
            }
            String keyS = this.key + "/";
            if (keyS.endsWith("/*view*/")) {
                return false;
            }
            ArtifactoryClient client = this.buildArtifactoryClient();
            try {
                bl = client.isFile(this.key);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Failed to check if %s is a file", this.key), (Throwable)e);
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean exists() throws IOException {
        return this.isDirectory() || this.isFile();
    }

    @NonNull
    public VirtualFile[] list() throws IOException {
        String prefix = Utils.stripTrailingSlash(this.key) + "/";
        List<VirtualFile> files = this.listFilesFromPrefix(prefix);
        if (files.isEmpty()) {
            return new VirtualFile[0];
        }
        return files.toArray(new VirtualFile[0]);
    }

    @NonNull
    public VirtualFile child(@NonNull String name) {
        String joinedKey = Utils.stripTrailingSlash(this.key) + "/" + name;
        return new ArtifactoryVirtualFile(joinedKey, this.build);
    }

    public long length() throws IOException {
        long l;
        block9: {
            if (this.fileInfo != null) {
                return this.fileInfo.getSize();
            }
            ArtifactoryClient client = this.buildArtifactoryClient();
            try {
                l = client.size(this.key);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Failed to get size of %s", this.key), (Throwable)e);
                    return 0L;
                }
            }
            client.close();
        }
        return l;
    }

    public long lastModified() throws IOException {
        long l;
        block9: {
            if (this.fileInfo != null) {
                return this.fileInfo.getLastUpdated();
            }
            ArtifactoryClient client = this.buildArtifactoryClient();
            try {
                l = client.lastUpdated(this.key);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Failed to get last updated time of %s", this.key), (Throwable)e);
                    return 0L;
                }
            }
            client.close();
        }
        return l;
    }

    public boolean canRead() throws IOException {
        return true;
    }

    public InputStream open() throws IOException {
        InputStream inputStream;
        block10: {
            LOGGER.debug(String.format("Opening %s...", this.key));
            if (this.isDirectory()) {
                throw new FileNotFoundException("Cannot open it because it is a directory.");
            }
            if (!this.isFile()) {
                throw new FileNotFoundException("Cannot open it because it is not a file.");
            }
            ArtifactoryClient client = this.buildArtifactoryClient();
            try {
                inputStream = client.downloadArtifact(this.key);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Failed to open %s", this.key), (Throwable)e);
                    throw new IOException(e);
                }
            }
            client.close();
        }
        return inputStream;
    }

    private ArtifactoryClient buildArtifactoryClient() {
        ArtifactoryGenericArtifactConfig config = Utils.getArtifactConfig();
        return new ArtifactoryClient(config.getServerUrl(), config.getRepository(), (UsernamePasswordCredentials)Utils.getCredentials());
    }

    private String normalizePath(String path) {
        String normalized = path.replaceAll("//+", "/");
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return normalized;
    }

    private List<VirtualFile> listFilesFromPrefix(String prefix) {
        List<VirtualFile> list;
        block8: {
            ArtifactoryClient client = this.buildArtifactoryClient();
            try {
                List<ArtifactoryClient.FileInfo> files = client.list(prefix);
                HashSet seen = new HashSet();
                String normalizedPrefix = this.normalizePath(prefix);
                list = files.stream().map(fileInfo -> {
                    boolean isFolder;
                    String immediateName;
                    String normalizedPath = this.normalizePath(fileInfo.getPath());
                    String relativePath = normalizedPath.startsWith(normalizedPrefix) ? normalizedPath.substring(normalizedPrefix.length()) : normalizedPath;
                    int slashIndex = relativePath.indexOf(47);
                    String string = immediateName = slashIndex == -1 ? relativePath : relativePath.substring(0, slashIndex);
                    if (!seen.add(immediateName)) {
                        return null;
                    }
                    boolean bl = isFolder = slashIndex != -1;
                    if (isFolder) {
                        String folderPath = normalizedPrefix + immediateName;
                        ArtifactoryClient.FileInfo folderInfo = new ArtifactoryClient.FileInfo(folderPath, fileInfo.getLastUpdated(), 0L, AqlItemType.FOLDER);
                        return new ArtifactoryVirtualFile(folderInfo, this.build);
                    }
                    return new ArtifactoryVirtualFile((ArtifactoryClient.FileInfo)fileInfo, this.build);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Failed to list files from prefix %s", prefix), (Throwable)e);
                    return Collections.emptyList();
                }
            }
            client.close();
        }
        return list;
    }
}

