/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactory_artifacts;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.artifactory_artifacts.ArtifactoryClient;
import io.jenkins.plugins.artifactory_artifacts.Utils;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ArtifactoryGenericArtifactConfig
extends AbstractDescribableImpl<ArtifactoryGenericArtifactConfig>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SERVER_URL_REGEXP = "^(http://|https://)[a-z0-9][a-z0-9-.]{0,}(?::[0-9]{1,5})?(/[0-9a-zA-Z_]*)*$";
    private static final Pattern endPointPattern = Pattern.compile("^(http://|https://)[a-z0-9][a-z0-9-.]{0,}(?::[0-9]{1,5})?(/[0-9a-zA-Z_]*)*$", 2);
    public static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryGenericArtifactConfig.class);
    public static final int DEFAULT_MAX_UPLOAD_RETRIES = 0;
    public static final int DEFAULT_RETRY_DELAY_SECONDS = 5;
    private String storageCredentialId;
    private String serverUrl;
    private String repository;
    private String prefix;
    private int maxUploadRetries = 0;
    private int retryDelaySeconds = 5;

    @DataBoundConstructor
    public ArtifactoryGenericArtifactConfig() {
    }

    public ArtifactoryGenericArtifactConfig(String storageCredentialId, String serverUrl, String repository, String prefix) {
        this.storageCredentialId = storageCredentialId;
        this.serverUrl = serverUrl;
        this.repository = repository;
        this.prefix = prefix;
        this.maxUploadRetries = 0;
        this.retryDelaySeconds = 5;
    }

    public ArtifactoryGenericArtifactConfig(String storageCredentialId, String serverUrl, String repository, String prefix, int maxUploadRetries, int retryDelaySeconds) {
        this.storageCredentialId = storageCredentialId;
        this.serverUrl = serverUrl;
        this.repository = repository;
        this.prefix = prefix;
        this.maxUploadRetries = maxUploadRetries;
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public String getStorageCredentialId() {
        return this.storageCredentialId;
    }

    @DataBoundSetter
    public void setStorageCredentialId(String storageCredentialId) {
        this.storageCredentialId = storageCredentialId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    @DataBoundSetter
    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getMaxUploadRetries() {
        return this.maxUploadRetries;
    }

    @DataBoundSetter
    public void setMaxUploadRetries(int maxUploadRetries) {
        this.maxUploadRetries = Math.max(0, maxUploadRetries);
    }

    public int getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    @DataBoundSetter
    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = Math.max(0, retryDelaySeconds);
    }

    public static ArtifactoryGenericArtifactConfig get() {
        return (ArtifactoryGenericArtifactConfig)ExtensionList.lookupSingleton(ArtifactoryGenericArtifactConfig.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ArtifactoryGenericArtifactConfig> {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Generic";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillStorageCredentialIdItems(@AncestorInPath Item item) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(ArtifactoryGenericArtifactConfig.get().getStorageCredentialId());
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeCurrentValue(ArtifactoryGenericArtifactConfig.get().getStorageCredentialId());
        }

        public FormValidation doCheckPrefix(@QueryParameter String prefix) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = StringUtils.isBlank((CharSequence)prefix) ? FormValidation.ok((String)"Artifacts will be stored in the root folder of the Artifactory Repository.") : (prefix.endsWith("/") ? FormValidation.ok() : FormValidation.error((String)"A prefix must end with a slash."));
            return ret;
        }

        public FormValidation doCheckRepository(@QueryParameter String repository) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((CharSequence)repository)) {
                ret = FormValidation.error((String)"Repository cannot be blank");
            }
            return ret;
        }

        public FormValidation doCheckServerUrl(@QueryParameter String serverUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isBlank((CharSequence)serverUrl)) {
                ret = FormValidation.error((String)"Server url cannot be blank");
            } else if (!endPointPattern.matcher(serverUrl).matches()) {
                ret = FormValidation.error((String)"Server url doesn't seem valid. Should start with http:// or https://");
            }
            return ret;
        }

        public FormValidation doCheckMaxUploadRetries(@QueryParameter int maxUploadRetries) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (maxUploadRetries < 0) {
                return FormValidation.error((String)"Max retries cannot be negative");
            }
            if (maxUploadRetries > 10) {
                return FormValidation.warning((String)"Consider using a lower number of retries to avoid long delays");
            }
            if (maxUploadRetries == 0) {
                return FormValidation.ok((String)"No retries - operations will fail immediately on first error");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRetryDelaySeconds(@QueryParameter int retryDelaySeconds) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (retryDelaySeconds < 0) {
                return FormValidation.error((String)"Retry delay cannot be negative");
            }
            if (retryDelaySeconds > 300) {
                return FormValidation.warning((String)"Consider using a shorter delay to avoid very long waits");
            }
            if (retryDelaySeconds == 0) {
                return FormValidation.ok((String)"No delay - retries will happen immediately");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doValidateArtifactoryConfig(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="storageCredentialId") String storageCredentialId, @QueryParameter(value="repository") String repository, @QueryParameter(value="prefix") String prefix) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)serverUrl) || StringUtils.isBlank((CharSequence)storageCredentialId) || StringUtils.isBlank((CharSequence)repository)) {
                return FormValidation.error((String)"Fields required");
            }
            try {
                Path tmpFile = Files.createTempFile("tmp-", "jenkins-artifactory-plugin-test", new FileAttribute[0]);
                ArtifactoryClient client = new ArtifactoryClient(serverUrl, repository, (UsernamePasswordCredentials)Utils.getCredentials(storageCredentialId));
                client.uploadArtifact(tmpFile, Utils.getPath(prefix, tmpFile));
                client.deleteArtifact(Utils.getPath(prefix, tmpFile));
                LOGGER.debug("Artifactory configuration validated");
            }
            catch (Exception e) {
                LOGGER.error("Unable to connect to Artifactory. Please check the server url and credentials", (Throwable)e);
                return FormValidation.error((String)("Unable to connect to Artifactory. Please check the server url and credentials : " + e.getMessage()));
            }
            return FormValidation.ok((String)"Success");
        }
    }
}

