/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.requests;

import com.amazon.inspector.jenkins.amazoninspectorbuildstep.AmazonInspectorBuilder;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.protocols.json.internal.unmarshall.document.DocumentUnmarshaller;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeVisitor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.inspectorscan.InspectorScanClient;
import software.amazon.awssdk.services.inspectorscan.InspectorScanClientBuilder;
import software.amazon.awssdk.services.inspectorscan.model.OutputFormat;
import software.amazon.awssdk.services.inspectorscan.model.ScanSbomRequest;
import software.amazon.awssdk.services.inspectorscan.model.ScanSbomResponse;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;

public class SdkRequests {
    private final String region;
    private final AmazonWebServicesCredentials awsCredential;
    private final String oidc;
    private final String roleArn;
    private final String awsProfileName;

    public SdkRequests(String region, AmazonWebServicesCredentials awsCredential, String oidc, String awsProfileName, String roleArn) {
        this.region = region;
        this.awsCredential = awsCredential;
        this.awsProfileName = awsProfileName;
        this.roleArn = roleArn;
        this.oidc = oidc;
    }

    public String requestSbom(String sbom) {
        SdkHttpClient client = ApacheHttpClient.builder().build();
        String workingProfileName = this.awsProfileName;
        AmazonWebServicesCredentials workingCredential = this.awsCredential;
        String workingOidc = this.oidc;
        boolean retry = true;
        while (true) {
            try {
                InspectorScanClient scanClient = (InspectorScanClient)((InspectorScanClientBuilder)((InspectorScanClientBuilder)((InspectorScanClientBuilder)((InspectorScanClientBuilder)InspectorScanClient.builder().region(Region.of((String)this.region))).httpClient(client)).credentialsProvider(this.getCredentialProvider(workingProfileName, workingOidc, workingCredential))).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putHeader("Accept-Encoding", "gzip").build())).build();
                JsonNodeParser jsonNodeParser = JsonNodeParser.create();
                DocumentUnmarshaller unmarshaller = new DocumentUnmarshaller();
                Document document = (Document)jsonNodeParser.parse(sbom).visit((JsonNodeVisitor)unmarshaller);
                ScanSbomRequest request = (ScanSbomRequest)ScanSbomRequest.builder().sbom(document).outputFormat(OutputFormat.CYCLONE_DX_1_5).build();
                ScanSbomResponse response = scanClient.scanSbom(request);
                return response.sbom().toString();
            }
            catch (Exception e) {
                AmazonInspectorBuilder.logger.println(e);
                if (!retry) {
                    throw e;
                }
                retry = false;
                AmazonInspectorBuilder.logger.println("An issue occurred while authenticating, attempting to authenticate with default credential provider chain");
                workingProfileName = "default";
                workingCredential = null;
                workingOidc = null;
                continue;
            }
            break;
        }
    }

    @SuppressFBWarnings
    private AwsCredentialsProvider getCredentialProvider(String workingProfileName, String workingOidc, AmazonWebServicesCredentials workingCredential) {
        StsClient stsClient = (StsClient)((StsClientBuilder)StsClient.builder().region(Region.of((String)this.region))).build();
        if (workingCredential != null) {
            AmazonInspectorBuilder.logger.println("Using explicitly provided AWS credentials to authenticate.");
            return StaticCredentialsProvider.create((AwsCredentials)this.createRawCredentialProvider(workingCredential).resolveCredentials());
        }
        if (this.roleArn != null && !this.roleArn.isEmpty() && workingOidc != null && !workingOidc.isEmpty()) {
            AmazonInspectorBuilder.logger.println("Using OAuth token and role to authenticate.");
            stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(this.createRawCredentialProvider(workingCredential))).region(Region.of((String)this.region))).build();
            AssumeRoleWithWebIdentityRequest webIdentityRequest = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().roleArn(this.roleArn).roleSessionName("inspectorscan").webIdentityToken(workingOidc).build();
            stsClient.assumeRoleWithWebIdentity(webIdentityRequest);
            return ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(webIdentityRequest).build();
        }
        if (this.roleArn != null && !this.roleArn.isEmpty()) {
            AmazonInspectorBuilder.logger.println("Authenticating to STS via a role and default credential provider chain.");
            return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName("inspectorscan").build()).build();
        }
        if (workingProfileName != null && !workingProfileName.isEmpty()) {
            AmazonInspectorBuilder.logger.println(String.format("AWS Credential and role not provided, authenticating using \"%s\" as profile name.", workingProfileName));
            return ProfileCredentialsProvider.builder().profileName(workingProfileName).build();
        }
        AmazonInspectorBuilder.logger.println("Using default credential provider chain to authenticate.");
        return DefaultCredentialsProvider.create();
    }

    private AwsCredentialsProvider createRawCredentialProvider(final AmazonWebServicesCredentials workingCredential) {
        return () -> new AwsCredentials(){

            public String accessKeyId() {
                return workingCredential.getCredentials().getAWSAccessKeyId();
            }

            public String secretAccessKey() {
                return workingCredential.getCredentials().getAWSSecretKey();
            }
        };
    }
}

