/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.inspector.jenkins.amazoninspectorbuildstep.html;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class HtmlJarHandler {
    public String jarPath;
    public String htmlData;

    public FilePath copyHtmlToDir(FilePath workspace, String buildId) throws IOException, InterruptedException {
        String htmlFileName = "index.html";
        String htmlStr = this.readStringFromJarEntry(htmlFileName);
        String injectedHtmlStr = this.injectHtmlData(htmlStr);
        FilePath htmlFile = workspace.child(String.format("%s/%s", buildId, htmlFileName));
        htmlFile.write(injectedHtmlStr, "UTF-8");
        return htmlFile;
    }

    public String injectHtmlData(String htmlContent) throws IOException {
        String scriptStart = "<script type=\"text/javascript\">";
        String trimmedJson = StringEscapeUtils.unescapeJava((String)this.htmlData).replace("\n", "").replace("\t", "");
        htmlContent = htmlContent.replaceAll(scriptStart, scriptStart + "\n\t\t\tconst txt = `" + trimmedJson + "`");
        return htmlContent;
    }

    @SuppressFBWarnings
    public String readStringFromJarEntry(String fileName) throws IOException {
        JarFile jarFile = new JarFile(this.jarPath);
        JarEntry entry = jarFile.getJarEntry(fileName);
        InputStream inputStream = jarFile.getInputStream(entry);
        String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        inputStream.close();
        jarFile.close();
        return content;
    }

    @Generated
    public HtmlJarHandler(String jarPath, String htmlData) {
        this.jarPath = jarPath;
        this.htmlData = htmlData;
    }
}

