/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.parsers;

import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import io.jenkins.tools.pluginmanager.parsers.PluginOutputConverter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AvailableUpdatesStdOutPluginOutputConverter
implements PluginOutputConverter {
    private final List<Plugin> originalPlugins;

    public AvailableUpdatesStdOutPluginOutputConverter(List<Plugin> originalPlugins) {
        this.originalPlugins = originalPlugins;
    }

    @Override
    public String convert(List<Plugin> plugins) {
        Map<String, Plugin> pluginsAsMap = plugins.stream().collect(Collectors.toMap(Plugin::getName, plugin -> plugin));
        StringBuilder builder = new StringBuilder("Available updates:\n");
        for (Plugin plugin2 : this.originalPlugins) {
            VersionNumber newVersion;
            VersionNumber originalVersion = plugin2.getVersion();
            if (!originalVersion.isOlderThan(newVersion = pluginsAsMap.get(plugin2.getName()).getVersion())) continue;
            builder.append(String.format("%s (%s) has an available update: %s%n", plugin2.getName(), plugin2.getVersion(), newVersion));
        }
        String result = builder.toString();
        if (!result.contains("has an")) {
            return "No available updates\n";
        }
        return result;
    }
}

