/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.analytics;

import hudson.ExtensionList;
import hudson.model.UsageStatistics;
import hudson.model.User;
import io.jenkins.blueocean.analytics.AdditionalAnalyticsProperties;
import io.jenkins.blueocean.analytics.Analytics;
import io.jenkins.blueocean.commons.DigestUtils;
import io.jenkins.blueocean.commons.ServiceException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractAnalytics
extends Analytics {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractAnalytics.class.getName());

    public boolean isEnabled() {
        return !UsageStatistics.DISABLED;
    }

    public void track(Analytics.TrackRequest req) {
        if (req == null) {
            throw new ServiceException.BadRequestException("missing request");
        }
        if (StringUtils.isEmpty((String)req.name)) {
            throw new ServiceException.BadRequestException("missing name");
        }
        HashMap<String, Object> allProps = req.properties == null ? new HashMap<String, Object>() : new HashMap(req.properties);
        for (AdditionalAnalyticsProperties enhancer : ExtensionList.lookup(AdditionalAnalyticsProperties.class)) {
            Map additionalProperties = enhancer.properties(req);
            if (additionalProperties == null) continue;
            allProps.putAll(additionalProperties);
        }
        if (Stapler.getCurrentRequest2() != null) {
            String identity = this.identity();
            allProps.put("userId", identity);
        }
        try {
            this.doTrack(req.name, allProps);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}, name: {}, props: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), req.name, allProps});
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("Failed to send event: {}, name: {}, props: {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), req.name, allProps});
            LOGGER.warn("Failed to send event", throwable);
        }
    }

    protected abstract void doTrack(String var1, Map<String, Object> var2);

    protected final String identity() {
        User user = User.current();
        String username = user == null ? "ANONYMOUS" : user.getId();
        return DigestUtils.sha256((String)username, (Charset)Charset.defaultCharset());
    }
}

