// CHECKSTYLE:OFF

package jenkins.plugins.blueocean.personalization;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code dashboardCard.input.favorite}: {@code Favorites}.
     * 
     * @return
     *     {@code Favorites}
     */
    public static String dashboardCard_input_favorite() {
        return holder.format("dashboardCard.input.favorite");
    }

    /**
     * Key {@code dashboardCard.input.favorite}: {@code Favorites}.
     * 
     * @return
     *     {@code Favorites}
     */
    public static Localizable _dashboardCard_input_favorite() {
        return new Localizable(holder, "dashboardCard.input.favorite");
    }

    /**
     * Key {@code no.default.branch.to.favorite}: {@code No default branch
     * (e.g. "master") to favorite}.
     * 
     * @return
     *     {@code No default branch (e.g. "master") to favorite}
     */
    public static String no_default_branch_to_favorite() {
        return holder.format("no.default.branch.to.favorite");
    }

    /**
     * Key {@code no.default.branch.to.favorite}: {@code No default branch
     * (e.g. "master") to favorite}.
     * 
     * @return
     *     {@code No default branch (e.g. "master") to favorite}
     */
    public static Localizable _no_default_branch_to_favorite() {
        return new Localizable(holder, "no.default.branch.to.favorite");
    }

    /**
     * Key {@code Favoriting.Error}: {@code Favoriting Error}.
     * 
     * @return
     *     {@code Favoriting Error}
     */
    public static String Favoriting_Error() {
        return holder.format("Favoriting.Error");
    }

    /**
     * Key {@code Favoriting.Error}: {@code Favoriting Error}.
     * 
     * @return
     *     {@code Favoriting Error}
     */
    public static Localizable _Favoriting_Error() {
        return new Localizable(holder, "Favoriting.Error");
    }

    /**
     * Key {@code dashboardCard.input.required}: {@code Input Required}.
     * 
     * @return
     *     {@code Input Required}
     */
    public static String dashboardCard_input_required() {
        return holder.format("dashboardCard.input.required");
    }

    /**
     * Key {@code dashboardCard.input.required}: {@code Input Required}.
     * 
     * @return
     *     {@code Input Required}
     */
    public static Localizable _dashboardCard_input_required() {
        return new Localizable(holder, "dashboardCard.input.required");
    }

}
