/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.config;

import hudson.Extension;
import hudson.Plugin;
import hudson.security.AuthorizationStrategy;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.SecurityRealm;
import hudson.util.VersionNumber;
import io.jenkins.blueocean.analytics.Analytics;
import io.jenkins.blueocean.auth.jwt.JwtTokenServiceEndpoint;
import io.jenkins.blueocean.commons.BlueOceanConfigProperties;
import io.jenkins.blueocean.commons.PageStatePreloader;
import io.jenkins.blueocean.rest.factory.BlueOceanConfigFactory;
import io.jenkins.blueocean.rest.model.BlueOceanConfig;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.util.JSONBuilder;

@Extension
public class BlueOceanConfigStatePreloader
extends PageStatePreloader {
    private static final Logger LOGGER = Logger.getLogger(BlueOceanConfigStatePreloader.class.getName());

    public String getStatePropertyPath() {
        return "config";
    }

    public String getStateJson() {
        StringWriter writer = new StringWriter();
        Jenkins jenkins = Jenkins.get();
        VersionNumber versionNumber = Jenkins.getVersion();
        String version = versionNumber != null ? versionNumber.toString() : Jenkins.VERSION;
        AuthorizationStrategy authorizationStrategy = jenkins.getAuthorizationStrategy();
        boolean allowAnonymousRead = true;
        if (authorizationStrategy instanceof FullControlOnceLoggedInAuthorizationStrategy) {
            allowAnonymousRead = ((FullControlOnceLoggedInAuthorizationStrategy)authorizationStrategy).isAllowAnonymousRead();
        }
        String jwtTokenEndpointHostUrl = Jenkins.get().getRootUrl();
        JwtTokenServiceEndpoint jwtTokenServiceEndpoint = JwtTokenServiceEndpoint.first();
        if (jwtTokenServiceEndpoint != null) {
            jwtTokenEndpointHostUrl = jwtTokenServiceEndpoint.getHostUrl();
        }
        this.addFeatures(new JSONBuilder((Writer)writer).object().key("version").value((Object)this.getBlueOceanPluginVersion()).key("jenkinsConfig").object().key("analytics").value(Analytics.isAnalyticsEnabled()).key("version").value((Object)version).key("security").object().key("enabled").value(jenkins.isUseSecurity()).key("loginUrl").value(jenkins.getSecurityRealm() == SecurityRealm.NO_AUTHENTICATION ? null : jenkins.getSecurityRealm().getLoginUrl()).key("authorizationStrategy").object().key("allowAnonymousRead").value(allowAnonymousRead).endObject().key("enableJWT").value(BlueOceanConfigProperties.BLUEOCEAN_FEATURE_JWT_AUTHENTICATION).key("jwtServiceHostUrl").value((Object)jwtTokenEndpointHostUrl).endObject().endObject()).endObject();
        return writer.toString();
    }

    private JSONBuilder addFeatures(JSONBuilder builder) {
        JSONBuilder features = builder.key("features").object();
        for (BlueOceanConfigFactory factory : BlueOceanConfigFactory.all()) {
            BlueOceanConfig config = factory.getConfig();
            for (String key : config.keys()) {
                features.key(key).value(config.get(key, Object.class));
            }
        }
        return features.endObject();
    }

    private String getBlueOceanPluginVersion() {
        Plugin plugin = Jenkins.get().getPlugin("blueocean-web");
        if (plugin == null) {
            return null;
        }
        return plugin.getWrapper().getVersion();
    }
}

