/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbUser;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.server.model.BbServerProject;
import io.jenkins.blueocean.rest.Utils;
import java.util.List;
import java.util.Map;

public class BbServerUser
extends BbUser {
    private final String displayName;
    private final String slug;
    private final String emailAddress;
    private final String avatar;

    @JsonCreator
    public BbServerUser(@JsonProperty(value="displayName") @NonNull String displayName, @JsonProperty(value="slug") @NonNull String slug, @JsonProperty(value="emailAddress") @NonNull String emailAddress, @JsonProperty(value="links") Map<String, List<Map<String, String>>> links) {
        this.displayName = displayName;
        this.slug = slug;
        this.emailAddress = emailAddress;
        List<Map<String, String>> hrefs = links.get("self");
        String a = null;
        for (Map<String, String> hrefLink : hrefs) {
            String href = hrefLink.get("href");
            if (href == null) continue;
            a = Utils.ensureTrailingSlash((String)href) + "avatar.png?s=50";
            break;
        }
        this.avatar = a;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="slug")
    public String getSlug() {
        return this.slug;
    }

    @Override
    @JsonProperty(value="emailAddress")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public String getAvatar() {
        return this.avatar;
    }

    @JsonIgnore
    public BbServerProject toPersonalProject() {
        return new BbServerProject("~" + this.slug, this.getDisplayName(), this.avatar);
    }
}

